/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.session;

import com.rocoinfo.rocomall.shiro.session.ShiroSession;
import com.rocoinfo.rocomall.shiro.session.ShiroSessionRepository;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingShiroSessionDao
extends CachingSessionDAO {
    private static final Logger logger = LoggerFactory.getLogger(CachingShiroSessionDao.class);
    private ShiroSessionRepository shiroSessionRepository;

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        boolean isLogin;
        Session session = super.getCachedSession(sessionId);
        Object principalSessionKey = null;
        if (session != null) {
            principalSessionKey = session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
        }
        boolean bl = isLogin = principalSessionKey != null;
        if (session == null || !isLogin) {
            session = this.doReadSession(sessionId);
            if (session == null) {
                throw new UnknownSessionException("There is no session with id [" + sessionId + "]");
            }
            ((ShiroSession)session).setChanged(true);
            super.update(session);
        }
        return session;
    }

    protected Session doReadSession(Serializable sessionId) {
        logger.debug("do read session {}", (Object)sessionId);
        return this.getShiroSessionRepository().getSession(sessionId);
    }

    public Session doReadSessionWithoutExpire(Serializable sessionId) {
        logger.debug("do read session WithoutExpire {}", (Object)sessionId);
        return this.getShiroSessionRepository().getSessionWithoutExpire(sessionId);
    }

    protected Serializable doCreate(Session session) {
        logger.debug("do create session");
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.getShiroSessionRepository().saveSession(session);
        return sessionId;
    }

    protected void doUpdate(Session session) {
        if (session instanceof ValidatingSession && !((ValidatingSession)session).isValid()) {
            return;
        }
        try {
            if (session instanceof ShiroSession) {
                ShiroSession ss = (ShiroSession)session;
                if (!ss.isChanged()) {
                    return;
                }
                ss.setChanged(false);
                ss.setLastAccessTime(new Date());
                this.shiroSessionRepository.saveSession(session);
            } else {
                logger.debug("sessionId {} name {} \u66f4\u65b0\u5931\u8d25", (Object)session.getId(), (Object)session.getClass().getName());
            }
        }
        catch (Exception e) {
            logger.warn("\u66f4\u65b0Session\u5931\u8d25", (Throwable)e);
        }
    }

    public void doDelete(Session session) {
        Serializable id = session.getId();
        if (id != null) {
            logger.debug("delete session id {}", (Object)id);
            this.getShiroSessionRepository().deleteSession(id);
        }
    }

    public void uncache(Serializable sessionId) {
        try {
            Session session = super.getCachedSession(sessionId);
            super.uncache(session);
            logger.debug("shiro session id {} \u7684\u7f13\u5b58\u5931\u6548", (Object)sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection<Session> getEhCacheActiveSessions() {
        return super.getActiveSessions();
    }

    public ShiroSessionRepository getShiroSessionRepository() {
        return this.shiroSessionRepository;
    }

    public void setShiroSessionRepository(ShiroSessionRepository shiroSessionRepository) {
        this.shiroSessionRepository = shiroSessionRepository;
    }
}

