/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.session;

import com.rocoinfo.rocomall.shiro.session.ShiroSessionRepository;
import java.io.Serializable;
import java.util.Collection;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomShiroSessionDAO
extends AbstractSessionDAO {
    private ShiroSessionRepository shiroSessionRepository;
    private Logger logger = LoggerFactory.getLogger(CustomShiroSessionDAO.class);

    public void update(Session session) throws UnknownSessionException {
        this.logger.debug("update session {}", (Object)session.getId());
        this.getShiroSessionRepository().saveSession(session);
    }

    public void delete(Session session) {
        if (session == null) {
            return;
        }
        Serializable id = session.getId();
        if (id != null) {
            this.logger.debug("delete session {}", (Object)id);
            this.getShiroSessionRepository().deleteSession(id);
        }
    }

    public Collection<Session> getActiveSessions() {
        this.logger.debug("get active sessions");
        return this.getShiroSessionRepository().getAllSessions();
    }

    protected Serializable doCreate(Session session) {
        this.logger.debug("do create session");
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.getShiroSessionRepository().saveSession(session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        this.logger.debug("do read session {}", (Object)sessionId);
        return this.getShiroSessionRepository().getSession(sessionId);
    }

    public ShiroSessionRepository getShiroSessionRepository() {
        return this.shiroSessionRepository;
    }

    public void setShiroSessionRepository(ShiroSessionRepository shiroSessionRepository) {
        this.shiroSessionRepository = shiroSessionRepository;
    }
}

