/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.session;

import com.rocoinfo.rocomall.shiro.JedisManager;
import com.rocoinfo.rocomall.shiro.session.ShiroSessionRepository;
import com.rocoinfo.rocomall.utils.SerializeUtil;
import java.io.Serializable;
import java.util.Collection;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JedisShiroSessionRepository
implements ShiroSessionRepository {
    public static final String REDIS_SHIRO_SESSION = "shiro-session:";
    private static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    private JedisManager jedisManager;
    private long sessionTimeOut = 1800000L;
    private final Logger logger = LoggerFactory.getLogger(JedisShiroSessionRepository.class);

    public void saveSession(Session session) {
        if (session == null || session.getId() == null) {
            throw new NullPointerException("session is empty");
        }
        try {
            this.logger.debug("save session {}", (Object)session.getId());
            byte[] key = SerializeUtil.serialize((Object)this.buildRedisSessionKey(session.getId()));
            byte[] value = SerializeUtil.serialize((Object)session);
            session.setTimeout(this.sessionTimeOut);
            Long expireTime = this.sessionTimeOut / 1000L;
            this.getJedisManager().saveValueByKey(key, value, expireTime.intValue());
        }
        catch (Exception e) {
            this.logger.error("save session error", (Throwable)e);
        }
    }

    public void deleteSession(Serializable id) {
        if (id == null) {
            throw new NullPointerException("session id is empty");
        }
        try {
            this.logger.debug("delete session {}", (Object)id);
            this.getJedisManager().deleteByKey(SerializeUtil.serialize((Object)this.buildRedisSessionKey(id)));
        }
        catch (Exception e) {
            this.logger.error("delete session error", (Throwable)e);
        }
    }

    public Session getSession(Serializable id) {
        if (id == null) {
            throw new NullPointerException("session id is empty");
        }
        Session session = null;
        try {
            this.logger.debug("get session {}", (Object)id);
            byte[] value = this.getJedisManager().getValueByKey(SerializeUtil.serialize((Object)this.buildRedisSessionKey(id)));
            session = (Session)SerializeUtil.deserialize((byte[])value, Session.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("get session error {}", (Object)id);
        }
        return session;
    }

    public Collection<Session> getAllSessions() {
        this.logger.debug("get all sessions");
        return null;
    }

    private String buildRedisSessionKey(Serializable sessionId) {
        return REDIS_SHIRO_SESSION + sessionId;
    }

    public JedisManager getJedisManager() {
        return this.jedisManager;
    }

    public void setJedisManager(JedisManager jedisManager) {
        this.jedisManager = jedisManager;
    }

    public long getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(long sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public Session getSessionWithoutExpire(Serializable sessionId) {
        return this.getSession(sessionId);
    }
}

