/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.session;

import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.shiro.JedisManager;
import com.rocoinfo.rocomall.shiro.SerializeObjectUtil;
import com.rocoinfo.rocomall.shiro.session.ShiroSessionRepository;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JedisShiroSessionToStringRepository
implements ShiroSessionRepository {
    public static final String REDIS_SHIRO_SESSION_PREFIX = "shiro-session-str:";
    private static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    private JedisManager jedisManager;
    private long sessionTimeOut = 1800000L;
    private final Logger logger = LoggerFactory.getLogger(JedisShiroSessionToStringRepository.class);

    public void saveSession(Session session) {
        if (session == null || session.getId() == null) {
            throw new NullPointerException("session is empty");
        }
        try {
            this.logger.debug("save session {}", (Object)session.getId());
            String key = this.buildRedisSessionKey(session.getId());
            String sessionString = SerializeObjectUtil.serializeToString((Serializable)((SimpleSession)session));
            session.setTimeout(this.sessionTimeOut);
            long expireTime = this.sessionTimeOut / 1000L;
            this.getJedisManager().setex(key, sessionString, (int)expireTime);
        }
        catch (Exception e) {
            this.logger.error("save session error", (Throwable)e);
        }
    }

    public void deleteSession(Serializable id) {
        if (id == null) {
            throw new NullPointerException("session id is empty");
        }
        try {
            this.logger.debug("delete session {}", (Object)id);
            this.getJedisManager().del(new String[]{this.buildRedisSessionKey(id)});
        }
        catch (Exception e) {
            this.logger.error("delete session error", (Throwable)e);
        }
    }

    public Session getSession(Serializable id) {
        if (id == null) {
            throw new NullPointerException("session id is empty");
        }
        Session session = null;
        try {
            this.logger.debug("get redis session {}", (Object)id);
            session = (Session)this.getJedisManager().execute((JedisTemplate.JedisAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("get redis session error {}", (Object)id);
        }
        return session;
    }

    public Session getSessionWithoutExpire(Serializable sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("session id is empty");
        }
        String key = this.buildRedisSessionKey(sessionId);
        String sessionString = this.getJedisManager().get(key);
        Session session = null;
        if (StringUtils.isNotBlank((CharSequence)sessionString)) {
            session = (Session)SerializeObjectUtil.deserializeFromString((String)sessionString);
        }
        return session;
    }

    public Collection<Session> getAllSessions() {
        this.logger.debug("get all sessions");
        return null;
    }

    private String buildRedisSessionKey(Serializable sessionId) {
        return REDIS_SHIRO_SESSION_PREFIX + sessionId;
    }

    public JedisManager getJedisManager() {
        return this.jedisManager;
    }

    public void setJedisManager(JedisManager jedisManager) {
        this.jedisManager = jedisManager;
    }

    public long getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(long sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    static /* synthetic */ String access$000(JedisShiroSessionToStringRepository x0, Serializable x1) {
        return x0.buildRedisSessionKey(x1);
    }

    static /* synthetic */ long access$100(JedisShiroSessionToStringRepository x0) {
        return x0.sessionTimeOut;
    }
}

