/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.session;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.shiro.session.mgt.SimpleSession;

public class ShiroSession
extends SimpleSession
implements Serializable {
    private static final long serialVersionUID = 8104129209588421240L;
    private boolean isChanged;

    public ShiroSession() {
        this.setChanged(true);
    }

    public ShiroSession(String host) {
        super(host);
        this.setChanged(true);
    }

    public void setId(Serializable id) {
        super.setId(id);
        this.setChanged(true);
    }

    public void setStopTimestamp(Date stopTimestamp) {
        super.setStopTimestamp(stopTimestamp);
        this.setChanged(true);
    }

    public void setExpired(boolean expired) {
        super.setExpired(expired);
        this.setChanged(true);
    }

    public void setTimeout(long timeout) {
        long oldTimeOut = this.getTimeout();
        if (oldTimeOut != timeout) {
            super.setTimeout(timeout);
            this.setChanged(true);
        }
    }

    public void setHost(String host) {
        super.setHost(host);
        this.setChanged(true);
    }

    public void setAttributes(Map<Object, Object> attributes) {
        super.setAttributes(attributes);
        this.setChanged(true);
    }

    public void setAttribute(Object key, Object value) {
        Object obj = this.getAttribute(key);
        if (obj != null && obj.equals(value)) {
            return;
        }
        super.setAttribute(key, value);
        this.setChanged(true);
    }

    public Object removeAttribute(Object key) {
        this.setChanged(true);
        return super.removeAttribute(key);
    }

    public void stop() {
        super.stop();
        this.setChanged(true);
    }

    protected void expire() {
        this.stop();
        this.setExpired(true);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected boolean onEquals(SimpleSession ss) {
        return super.onEquals(ss);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }
}

