/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.session;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.shiro.session.CachingShiroSessionDao;
import com.rocoinfo.rocomall.shiro.session.ShiroSession;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroSessionService {
    private Logger logger = LoggerFactory.getLogger(ShiroSessionService.class);
    public static final String CHANNEL = "shiro.session.uncache";
    @Autowired
    private CachingShiroSessionDao sessionDao;
    @Autowired
    private JedisTemplate jedisTemplate;

    public ShiroSession getSession() {
        return (ShiroSession)this.sessionDao.doReadSessionWithoutExpire(SecurityUtils.getSubject().getSession().getId());
    }

    public void setId(Serializable id) {
        ShiroSession session = this.getSession();
        session.setId(id);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void setStopTimestamp(Date stopTimestamp) {
        ShiroSession session = this.getSession();
        session.setStopTimestamp(stopTimestamp);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void setExpired(boolean expired) {
        ShiroSession session = this.getSession();
        session.setExpired(expired);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void setTimeout(long timeout) {
        ShiroSession session = this.getSession();
        session.setTimeout(timeout);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void setHost(String host) {
        ShiroSession session = this.getSession();
        session.setHost(host);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void setAttributes(Map<Object, Object> attributes) {
        ShiroSession session = this.getSession();
        session.setAttributes(attributes);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public Map<Object, Object> getAttributes() {
        return this.getSession().getAttributes();
    }

    public void setAttribute(Object key, Object value) {
        ShiroSession session = this.getSession();
        session.setAttribute(key, value);
        this.sessionDao.update((Session)session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void setAttribute(Session session, Object key, Object value) {
        session.setAttribute(key, value);
        this.sessionDao.update(session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void notifyUpdateSession(Session session) {
        this.sessionDao.update(session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public void deleteSession(Session session) {
        this.sessionDao.delete(session);
        this.jedisTemplate.publish(CHANNEL, session.getId());
    }

    public Object getAttribute(Object key) {
        return this.getSession().getAttribute(key);
    }

    public Collection<Object> getAttributeKeys() {
        return this.getSession().getAttributeKeys();
    }

    public Object removeAttribute(Object key) {
        ShiroSession session = this.getSession();
        Object removeObj = session.removeAttribute(key);
        if (removeObj != null) {
            this.sessionDao.update((Session)session);
            this.jedisTemplate.publish(CHANNEL, session.getId());
        }
        return removeObj;
    }

    public List<Map<String, Object>> getActiveSessions() {
        LinkedList sessions = Lists.newLinkedList();
        Collection activeSession = this.sessionDao.getActiveSessions();
        for (Session session : activeSession) {
            HashMap map = Maps.newHashMap();
            SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            if (principalCollection != null) {
                List listPrincipals = principalCollection.asList();
                Map attributes = (Map)listPrincipals.get(1);
                map.put("loginName", listPrincipals.get(0));
                map.put("name", attributes.get("name"));
                map.put("ip", attributes.get("ip"));
            } else {
                map.put("loginName", "\u672a\u767b\u5f55");
                map.put("name", "\u672a\u767b\u5f55");
                map.put("ip", "\u672a\u767b\u5f55");
            }
            map.put("startTimestamp", session.getStartTimestamp());
            map.put("lastAccessTime", session.getLastAccessTime());
            sessions.add(map);
        }
        return sessions;
    }

    public void flushRedis() {
        Collection activeSession = this.sessionDao.getActiveSessions();
        if (activeSession != null) {
            for (Session session : activeSession) {
                try {
                    this.sessionDao.doDelete(session);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void flushEhCache() {
        HashSet sessions = Sets.newHashSet();
        Collection ehCacheActiveSession = this.sessionDao.getEhCacheActiveSessions();
        Collection activeSession = this.sessionDao.getActiveSessions();
        if (CollectionUtils.isNotEmpty((Collection)ehCacheActiveSession)) {
            sessions.addAll(ehCacheActiveSession);
        }
        if (CollectionUtils.isNotEmpty((Collection)activeSession)) {
            sessions.addAll(activeSession);
        }
        for (Session session : sessions) {
            try {
                this.sessionDao.uncache(session.getId());
            }
            catch (Exception exception) {}
        }
        this.logger.info("flushEhCache Project EhCacheActiveSessions {} ", (Object)this.sessionDao.getEhCacheActiveSessions().size());
    }

    public void flushAll() {
        Collection activeSession = this.sessionDao.getActiveSessions();
        if (activeSession != null) {
            for (Session session : activeSession) {
                try {
                    this.sessionDao.delete(session);
                }
                catch (Exception exception) {}
            }
        }
    }
}

