/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CookieUtil {
    public static final String CART_ITEM_COOKIE_NAME_PREFIX = "cartItem_";
    public static final String SSO_TOKEN_COOKIE_NAME = "JJCToken16";
    private static final String OPEN_ID_COOKIE_NAME = "cookie_openId";

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge, String path) {
        Cookie cookie;
        if (maxAge == null) {
            maxAge = 0;
        }
        if (value == null) {
            value = "";
        }
        if (path == null) {
            path = "/";
        }
        if (null == (cookie = CookieUtil.getCookie((HttpServletRequest)request, (String)name))) {
            cookie = new Cookie(name, value);
        }
        cookie.setMaxAge(maxAge.intValue());
        cookie.setPath(path);
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookiePath) {
        CookieUtil.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)"", (Integer)0, (String)cookiePath);
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        return (Cookie)CookieUtil.readCookieMap((HttpServletRequest)request).get(cookieName);
    }

    public static String getSsoTokenCookieValue(HttpServletRequest request) {
        Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, (String)"JJCToken16");
        if (cookie != null) {
            return cookie.getValue();
        }
        return "";
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        LinkedHashMap cookieMap = Maps.newLinkedHashMap();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (int i = 0; i < cookies.length; ++i) {
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
        return cookieMap;
    }

    public static Map<Long, Integer> readCartItemCookieMap(HttpServletRequest request) {
        LinkedHashMap itemQtMap = Maps.newLinkedHashMap();
        for (Map.Entry entry : CookieUtil.readCookieMap((HttpServletRequest)request).entrySet()) {
            String cookieName = (String)entry.getKey();
            Cookie cookie = (Cookie)entry.getValue();
            if (!cookieName.startsWith(WebUtils.getLoggedUserId() + "cartItem_")) continue;
            String cookieValue = cookie.getValue();
            Long unitProdId = NumberUtils.toLong((String)cookieName.substring((WebUtils.getLoggedUserId() + "cartItem_").length()));
            itemQtMap.put(unitProdId, NumberUtils.toInt((String)cookieValue));
        }
        return itemQtMap;
    }

    public static int getCartItemBoughtQuantity(HttpServletRequest request, long skuId) {
        String cookieName = "cartItem_" + skuId;
        Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, (String)cookieName);
        int qty = 0;
        if (cookie != null) {
            qty = NumberUtils.toInt((String)cookie.getValue());
        }
        return qty;
    }

    public static void addCartItemToCookie(HttpServletRequest request, HttpServletResponse response, long skuId, int quantity) {
        String cookieName = WebUtils.getLoggedUserId() + "cartItem_" + skuId;
        int qty = CookieUtil.getCartItemBoughtQuantity((HttpServletRequest)request, (long)skuId);
        CookieUtil.addOrUpdateCartItemCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)String.valueOf(qty += quantity));
    }

    public static void modifyCookieCartItemQt(HttpServletRequest request, HttpServletResponse response, long skuId, int quantity) {
        String cookieName = WebUtils.getLoggedUserId() + "cartItem_" + skuId;
        if (quantity < 1) {
            quantity = 1;
        }
        CookieUtil.addOrUpdateCartItemCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)String.valueOf(quantity));
    }

    public static String getCookieOpenId(HttpServletRequest request) {
        String openId = "";
        Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, (String)"cookie_openId");
        if (cookie != null) {
            openId = cookie.getValue();
        }
        return openId;
    }

    public static void addOpenIdToCookie(HttpServletRequest request, HttpServletResponse response, String openId) {
        int maxAge = 31536000;
        String cookiePath = CookieUtil.getCookieStorePath((HttpServletRequest)request);
        CookieUtil.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cookie_openId", (String)cookiePath);
        CookieUtil.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"cookie_openId", (String)openId, (Integer)maxAge, (String)cookiePath);
    }

    public static void removeCartItemCookie(HttpServletRequest request, HttpServletResponse response, Long ... skuIds) {
        if (!ArrayUtils.isEmpty((Object[])skuIds)) {
            for (Long skuId : skuIds) {
                String cookieName = WebUtils.getLoggedUserId() + "cartItem_" + skuId;
                CookieUtil.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)CookieUtil.getCookieStorePath((HttpServletRequest)request));
            }
        }
    }

    public static void clearCartCookies(HttpServletRequest request, HttpServletResponse response) {
        for (Long skuId : CookieUtil.readCartItemCookieMap((HttpServletRequest)request).keySet()) {
            CookieUtil.removeCartItemCookie((HttpServletRequest)request, (HttpServletResponse)response, (Long[])new Long[]{skuId});
        }
    }

    public static void batchSaveCartItemsToCookie(HttpServletRequest request, HttpServletResponse response, Map<Long, Integer> skuIdQtMap) {
        if (!CollectionUtils.isEmpty(skuIdQtMap)) {
            for (Map.Entry<Long, Integer> entry : skuIdQtMap.entrySet()) {
                Long skuId = entry.getKey();
                Integer quantity = entry.getValue();
                String cookieName = WebUtils.getLoggedUserId() + "cartItem_" + skuId;
                CookieUtil.addOrUpdateCartItemCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)String.valueOf(quantity));
            }
        }
    }

    private static void addOrUpdateCartItemCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue) {
        String cookieStorePath = CookieUtil.getCookieStorePath((HttpServletRequest)request);
        int maxAge = 5184000;
        CookieUtil.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)cookieStorePath);
        CookieUtil.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (String)cookieValue, (Integer)maxAge, (String)cookieStorePath);
    }

    private static String getCookieStorePath(HttpServletRequest request) {
        String slash = "/";
        String cookieStorePath = request.getContextPath();
        if (!cookieStorePath.endsWith("/")) {
            cookieStorePath = cookieStorePath.concat("/");
        }
        return cookieStorePath;
    }
}

