/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.entity.Sku;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public final class CustomFunctions {
    public static Map<String, List<String>> canDoMap = new HashMap();

    public static String abbreviate(String str, int maxWidth) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (maxWidth < 4) {
            return str;
        }
        return StringUtils.abbreviate((String)str, (int)maxWidth);
    }

    public static boolean contains(List<Object> itemList, Object item) {
        if (!CollectionUtils.isEmpty(itemList)) {
            return itemList.contains(item);
        }
        return false;
    }

    public static String encode(String paramValue, String charSet) {
        try {
            return URLEncoder.encode(paramValue, charSet);
        }
        catch (UnsupportedEncodingException e) {
            return paramValue;
        }
    }

    public static String renderMoney(double amount) {
        String money = "";
        int intPart = (int)amount;
        if (amount != (double)intPart) {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setMaximumFractionDigits(2);
            money = fmt.format(amount);
            money = money.replace(",", "");
        } else {
            money = String.valueOf(intPart);
        }
        return money;
    }

    public static boolean canDo(Sku sku, String action) {
        if (action == "list" && sku.getProduct().getDelistTime() != null && new Date().getTime() > sku.getProduct().getDelistTime().getTime()) {
            return false;
        }
        return canDoMap.get(sku.getProduct().getStatus().name()) != null && ((List)canDoMap.get(sku.getProduct().getStatus().name())).contains(action);
    }

    static {
        ArrayList<String> draft = new ArrayList<String>(3);
        draft.add("discard");
        draft.add("submitAudit");
        draft.add("edit");
        canDoMap.put("DRAFT", draft);
        ArrayList discard = new ArrayList(0);
        canDoMap.put("DISCARD", discard);
        ArrayList<String> audit = new ArrayList<String>(3);
        audit.add("auditRefuse");
        audit.add("auditOk");
        canDoMap.put("AUDIT", audit);
        ArrayList<String> refuse = new ArrayList<String>(2);
        refuse.add("discard");
        refuse.add("edit");
        canDoMap.put("REFUSE", refuse);
        ArrayList<String> ready_list = new ArrayList<String>(2);
        ready_list.add("list");
        ready_list.add("edit");
        canDoMap.put("READY_LIST", ready_list);
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("deList");
        canDoMap.put("LIST", list);
        ArrayList<String> delist = new ArrayList<String>(2);
        delist.add("list");
        delist.add("edit");
        canDoMap.put("DELIST", delist);
    }
}

