/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.utils.JsGenerator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JsGenerator {
    static final String slash = File.separator;

    public static void generateJsFile(String jsonJsBody, JsBlock block) throws IOException {
        String fileName = block.name() + ".js";
        JsGenerator.writeFile((String)jsonJsBody, (JsBlock)block, (String)fileName, (boolean)false);
    }

    public static void generateHashJsFile(ServletContext ctx, String jsonJsBody, JsBlock block) throws IOException {
        String pagePath = block.getAttachTo().name();
        String joinChar = "-";
        String md5 = DigestUtils.md5Hex((String)jsonJsBody);
        String md5CtxAttruteName = pagePath + "-" + block.name();
        ctx.setAttribute(md5CtxAttruteName, (Object)md5);
        String fileName = block.name() + "-" + md5 + ".js";
        JsGenerator.writeFile((String)jsonJsBody, (JsBlock)block, (String)fileName, (boolean)true);
    }

    private static void writeFile(String jsonJsBody, JsBlock block, String fileName, boolean isCleanOldVersionFile) throws IOException {
        String pagePath = block.getAttachTo().name();
        String dir = PropertyHolder.getJsGenerateDir() + slash + pagePath;
        File saveToDir = new File(dir);
        if (!saveToDir.exists()) {
            saveToDir.mkdirs();
        }
        if (StringUtils.isNotBlank((CharSequence)jsonJsBody)) {
            String jsFileContentFormat = "var _%s=%s;";
            jsonJsBody = String.format(jsFileContentFormat, block.name().toUpperCase(), jsonJsBody);
        }
        if (isCleanOldVersionFile) {
            JsGenerator.clearOldVersionJsFile((File)saveToDir, (JsBlock)block);
        }
        File jsFile = new File(saveToDir, fileName);
        FileUtils.write((File)jsFile, (CharSequence)jsonJsBody);
    }

    private static void clearOldVersionJsFile(File jsFileDir, JsBlock block) {
        File[] removeFiles = jsFileDir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (removeFiles != null && removeFiles.length > 0) {
            for (File rmFile : removeFiles) {
                FileUtils.deleteQuietly((File)rmFile);
            }
        }
    }
}

