/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.utils.WebUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;

public final class TokenProcessor {
    private static TokenProcessor instance = new TokenProcessor();
    public static final String TRANSACTION_TOKEN_KEY = "transactionToken";
    public static final String TOKEN_KEY = "htmlformToken";
    private long previous;

    public static TokenProcessor getInstance() {
        return instance;
    }

    protected TokenProcessor() {
    }

    public synchronized boolean isTokenValid(HttpServletRequest request) {
        return this.isTokenValid(request, false);
    }

    public synchronized boolean isTokenValid(HttpServletRequest request, boolean reset) {
        String token;
        Session session = WebUtils.getSession();
        if (session == null) {
            return false;
        }
        String saved = (String)session.getAttribute((Object)TRANSACTION_TOKEN_KEY);
        if (saved == null) {
            return false;
        }
        if (reset) {
            this.resetToken();
        }
        if ((token = request.getParameter(TOKEN_KEY)) == null) {
            return false;
        }
        return saved.equals(token);
    }

    public synchronized void resetToken() {
        Session session = WebUtils.getSession();
        if (session == null) {
            return;
        }
        session.removeAttribute((Object)TRANSACTION_TOKEN_KEY);
    }

    public synchronized void saveToken() {
        Session session = WebUtils.getSession();
        String token = this.generateToken();
        if (token != null) {
            session.setAttribute((Object)TRANSACTION_TOKEN_KEY, (Object)token);
        }
    }

    private synchronized String generateToken() {
        Session session = WebUtils.getSession();
        try {
            String sessionId = (String)((Object)session.getId());
            byte[] id = sessionId.getBytes();
            long current = System.currentTimeMillis();
            if (current == this.previous) {
                ++current;
            }
            this.previous = current;
            byte[] now = new Long(current).toString().getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(now);
            return this.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(Character.forDigit((buffer[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(buffer[i] & 0xF, 16));
        }
        return sb.toString();
    }
}

