/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.shiro.ShiroUser;
import com.rocoinfo.rocomall.utils.CookieUtil;
import com.rocoinfo.rocomall.utils.UserAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.Session;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springside.modules.utils.Collections3;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebUtils {
    public static ResponseEntity RESPONSE_200 = new ResponseEntity(HttpStatus.OK);

    private WebUtils() {
    }

    public static String getBaseSiteUrl(HttpServletRequest request) {
        StringBuilder basePath = new StringBuilder();
        basePath.append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80) {
            basePath.append(":").append(request.getServerPort());
        }
        basePath.append(request.getContextPath());
        return basePath.toString();
    }

    public static String getFullImageUrl(String imagePath) {
        return PropertyHolder.getImageBaseUrl() + imagePath;
    }

    public static List<Supplier> getManagedSuppliersOfLoginUser() {
        List suppliers = (List)WebUtils.getSession().getAttribute((Object)"suppliers");
        if (suppliers == null) {
            return Collections.emptyList();
        }
        return suppliers;
    }

    public static ShiroUser getLoggedUser() {
        try {
            return (ShiroUser)SecurityUtils.getSubject().getPrincipal();
        }
        catch (UnavailableSecurityManagerException ex) {
            return null;
        }
    }

    public static List<Long> getWhereClauseSupplierIds(Long supplierIdQueryParam) {
        ShiroUser shiroUser = WebUtils.getLoggedUser();
        List managedSupplierIds = Collections3.extractToList((Collection)WebUtils.getManagedSuppliersOfLoginUser(), (String)"id");
        if (CollectionUtils.isEmpty((Collection)managedSupplierIds)) {
            return managedSupplierIds;
        }
        ArrayList<Long> paramSupplierIds = new ArrayList<Long>();
        if (supplierIdQueryParam != null && supplierIdQueryParam > 0L && managedSupplierIds.contains(supplierIdQueryParam)) {
            paramSupplierIds.add(supplierIdQueryParam);
        } else {
            paramSupplierIds.addAll(managedSupplierIds);
        }
        return paramSupplierIds;
    }

    public static Long getLoggedUserId() {
        ShiroUser user = WebUtils.getLoggedUser();
        if (user == null) {
            return null;
        }
        return user.getId();
    }

    public static boolean isAjaxRequest(HttpServletRequest req) {
        String constant = "x-requested-with";
        String xRequestedWith = req.getHeader(constant);
        return StringUtils.isNotBlank((CharSequence)xRequestedWith) && StringUtils.equalsIgnoreCase((CharSequence)xRequestedWith, (CharSequence)"XMLHttpRequest");
    }

    public static boolean isLogged() {
        return WebUtils.getLoggedUserId() != null;
    }

    public static Session getSession() {
        return SecurityUtils.getSubject().getSession();
    }

    public static boolean isSmsVCodeValid(String vcode) {
        Session session = WebUtils.getSession();
        String sessionVcode = (String)session.getAttribute((Object)"vcode");
        if (StringUtils.isEmpty((CharSequence)sessionVcode)) {
            return false;
        }
        Long sendVcodeTimestamp = (Long)session.getAttribute((Object)"registerSmsCodeTimestamp");
        int count = Integer.parseInt(session.getAttribute((Object)"codeWrongCount").toString());
        if (count > 5) {
            session.removeAttribute((Object)"vcode");
            return false;
        }
        if (System.currentTimeMillis() - sendVcodeTimestamp > 300000L) {
            return false;
        }
        if (!sessionVcode.equalsIgnoreCase(vcode)) {
            session.setAttribute((Object)"codeWrongCount", (Object)(count + 1));
        }
        return sessionVcode.equalsIgnoreCase(vcode);
    }

    public static String getClientIpAddr(HttpServletRequest request) {
        List ips;
        String ipAddr;
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        String string = ipAddr = (ips = WebUtils.findMatchsContentsByRegex((String)ip, (String)"[\\d\\.]{7,15}")).size() > 0 ? (String)ips.get(0) : "0.0.0.0";
        if (StringUtils.isNotBlank((CharSequence)ipAddr) && ipAddr.length() > 20) {
            ipAddr = ipAddr.substring(0, 20);
        }
        return ipAddr;
    }

    public static String getOpenIdAndStoreCookieSession(HttpServletRequest request, HttpServletResponse resp) {
        String openId = request.getParameter("openId");
        Session session = WebUtils.getSession();
        String openIdInSession = "sessionOpenId";
        if (StringUtils.isBlank((CharSequence)openId)) {
            openId = (String)session.getAttribute((Object)"sessionOpenId");
            if (StringUtils.isEmpty((CharSequence)openId) && StringUtils.isNotBlank((CharSequence)(openId = CookieUtil.getCookieOpenId((HttpServletRequest)request)))) {
                session.setAttribute((Object)"sessionOpenId", (Object)openId);
            }
        } else {
            session.setAttribute((Object)"sessionOpenId", (Object)openId);
            CookieUtil.addOpenIdToCookie((HttpServletRequest)request, (HttpServletResponse)resp, (String)openId);
        }
        return StringUtils.trimToEmpty((String)openId);
    }

    public static UserAgent parseUserAgent(HttpServletRequest request) {
        String ua = StringUtils.trimToEmpty((String)request.getHeader("User-Agent"));
        UserAgent userAgent = new UserAgent();
        if (ua.contains("Windows")) {
            userAgent.setOsType(UserAgent.OsType.WINDOWS);
            if (ua.contains("Windows Phone")) {
                userAgent.setClientType(UserAgent.ClientType.WINDOWS_PHONE);
            } else {
                userAgent.setClientType(UserAgent.ClientType.PC);
            }
        } else if (ua.contains("Mac OS X")) {
            userAgent.setOsType(UserAgent.OsType.IOS);
            if (ua.contains("iPhone")) {
                userAgent.setClientType(UserAgent.ClientType.IPHONE);
            } else if (ua.contains("iPod")) {
                userAgent.setClientType(UserAgent.ClientType.ITOUCH);
            } else if (ua.contains("iPad")) {
                userAgent.setClientType(UserAgent.ClientType.IPAD);
            } else {
                userAgent.setClientType(UserAgent.ClientType.PC);
            }
        } else if (ua.contains("Linux")) {
            userAgent.setOsType(UserAgent.OsType.LINUX);
            if (ua.contains("Android")) {
                userAgent.setClientType(UserAgent.ClientType.ANDROID);
            } else {
                userAgent.setClientType(UserAgent.ClientType.PC);
            }
        }
        return userAgent;
    }

    public static List<String> findMatchsContentsByRegex(String sourceStr, String regex) {
        ArrayList<String> strList = new ArrayList<String>(0);
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sourceStr);
            while (matcher.find()) {
                strList.add(matcher.group());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strList;
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static ResponseEntity response400(String message) {
        return new ResponseEntity((Object)message, null, HttpStatus.BAD_REQUEST);
    }

    public static ResponseEntity response500(String message) {
        return new ResponseEntity((Object)message, null, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static void setStringValue(Map<String, Object> map, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            map.put(key, value);
        }
    }

    public static void setObjectValue(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

