/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public void zip(String srcfile, String destfile) {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destfile)));
            this.addZip(srcfile, out, "");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZip(String srcFilePath, ZipOutputStream zipOut, String parentPath) {
        try {
            File srcFile = new File(srcFilePath);
            if (srcFile.isFile()) {
                byte[] data = new byte[4096];
                BufferedInputStream buffIn = null;
                try {
                    int count;
                    FileInputStream in = new FileInputStream(srcFile);
                    buffIn = new BufferedInputStream(in, 4096);
                    ZipEntry entry = new ZipEntry(parentPath + srcFile.getName());
                    entry.setTime(srcFile.lastModified());
                    zipOut.putNextEntry(entry);
                    while ((count = buffIn.read(data, 0, 4096)) != -1) {
                        zipOut.write(data, 0, count);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(buffIn);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)buffIn);
            }
            if (srcFile.isDirectory()) {
                File[] files = srcFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.addZip(files[i].getAbsolutePath(), zipOut, parentPath + srcFile.getName() + "/");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unzip(String zipfile, String unzipToDir) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> emu = zf.entries();
            while (emu.hasMoreElements()) {
                int count;
                ZipEntry entry = emu.nextElement();
                if (entry.isDirectory()) {
                    new File(unzipToDir + "/" + entry.getName()).mkdirs();
                    continue;
                }
                BufferedInputStream bis = new BufferedInputStream(zf.getInputStream(entry));
                File file = new File(unzipToDir + "/" + entry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
                byte[] data = new byte[4096];
                while ((count = bis.read(data, 0, 4096)) != -1) {
                    bos.write(data, 0, count);
                }
                bos.flush();
                bos.close();
                bis.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

