/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.web;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.service.dict.IDictProviceCityService;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeTemplateService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/expressTemplate"})
public class ExpressTemplateController
extends BaseController {
    @Autowired
    protected IDictProviceCityService provCityService;
    @Autowired
    private IExpressFeeTemplateService expressTemplateService;

    @RequestMapping(value={"create"})
    public String createUI(Model model) {
        model.addAttribute("provCityList", (Object)this.provCityService.buildProvCityNodes(null));
        return "express/express_fee_template";
    }

    private void buildFeeItemCityNames(ExpressFeeTemplate feeTemplate) {
        if (feeTemplate != null && CollectionUtils.isNotEmpty((Collection)feeTemplate.getItems())) {
            for (ExpressFeeItem item : feeTemplate.getItems()) {
                StringBuilder idBuf = new StringBuilder();
                List itemCityList = item.getItemCitys();
                for (FeeItemCity itemCity : itemCityList) {
                    idBuf.append(itemCity.getCityId()).append(",");
                }
                if (idBuf.length() <= 0) continue;
                idBuf.deleteCharAt(idBuf.length() - 1);
                item.setCityIds(idBuf.toString());
            }
        }
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String updateUI(@PathVariable Long id, Model model) {
        ExpressFeeTemplate feeTemplate = this.expressTemplateService.getTemplateDetailById(id);
        this.buildFeeItemCityNames(feeTemplate);
        model.addAttribute("provCityList", (Object)this.provCityService.buildProvCityNodes(null));
        model.addAttribute("feeTemplate", (Object)feeTemplate);
        return "express/express_fee_template_edit";
    }
}

