/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.web;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.web.StaticContentServlet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.Velocity;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springside.modules.web.Servlets;

/*
 * Exception performing whole class analysis ignored.
 */
public class StaticContentServlet
extends HttpServlet {
    private static final long serialVersionUID = -1855617048198368534L;
    private static final String[] GZIP_MIME_TYPES = new String[]{"text/html", "application/xhtml+xml", "text/plain", "text/css", "text/javascript", "application/x-javascript", "application/json"};
    private static final int GZIP_MINI_LENGTH = 512;
    private MimetypesFileTypeMap mimetypesFileTypeMap;
    private ApplicationContext applicationContext;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OutputStream output;
        String contentPath = request.getPathInfo();
        if (StringUtils.isBlank((CharSequence)contentPath) || "/".equals(contentPath)) {
            response.sendError(400, "contentPath parameter is required.");
            return;
        }
        ContentInfo contentInfo = this.getContentInfo(contentPath);
        if (!contentInfo.file.exists()) {
            response.sendError(404, "file not found.");
            return;
        }
        if (!Servlets.checkIfModifiedSince((HttpServletRequest)request, (HttpServletResponse)response, (long)contentInfo.lastModified) || !Servlets.checkIfNoneMatchEtag((HttpServletRequest)request, (HttpServletResponse)response, (String)contentInfo.etag)) {
            return;
        }
        Servlets.setExpiresHeader((HttpServletResponse)response, (long)31536000L);
        Servlets.setLastModifiedHeader((HttpServletResponse)response, (long)contentInfo.lastModified);
        Servlets.setEtag((HttpServletResponse)response, (String)contentInfo.etag);
        response.setContentType(contentInfo.mimeType);
        if (request.getParameter("download") != null) {
            Servlets.setFileDownloadHeader((HttpServletResponse)response, (String)contentInfo.fileName);
        }
        if (StaticContentServlet.checkAccetptGzip((HttpServletRequest)request) && contentInfo.needGzip) {
            output = this.buildGzipOutputStream(response);
        } else {
            response.setContentLength(contentInfo.length);
            output = response.getOutputStream();
        }
        FileUtils.copyFile((File)contentInfo.file, (OutputStream)output);
        output.flush();
    }

    private static boolean checkAccetptGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return StringUtils.contains((CharSequence)acceptEncoding, (CharSequence)"gzip");
    }

    private OutputStream buildGzipOutputStream(HttpServletResponse response) throws IOException {
        response.setHeader("Content-Encoding", "gzip");
        response.setHeader("Vary", "Accept-Encoding");
        return new GZIPOutputStream((OutputStream)response.getOutputStream());
    }

    public void init() throws ServletException {
        this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.mimetypesFileTypeMap = new MimetypesFileTypeMap();
        this.mimetypesFileTypeMap.addMimeTypes("text/css css");
        this.initVelocityRuntime(this.getServletContext());
    }

    private void initVelocityRuntime(ServletContext ctx) {
        Properties velocityProps = new Properties();
        velocityProps.put("runtime.log", ctx.getRealPath("/WEB-INF/log/velocity.log"));
        velocityProps.put("file.resource.loader.path", ctx.getRealPath("/WEB-INF/vm"));
        velocityProps.put("input.encoding", "UTF-8");
        velocityProps.put("output.encoding", "UTF-8");
        velocityProps.setProperty("directive.foreach.counter.name", "velocityCount");
        velocityProps.setProperty("directive.foreach.counter.initial.value", "0");
        try {
            Velocity.init((Properties)velocityProps);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(" velocity\u521d\u59cb\u5316\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }

    private ContentInfo getContentInfo(String contentPath) {
        File file;
        ContentInfo contentInfo = new ContentInfo();
        String realFilePath = PropertyHolder.getUploadDir() + contentPath;
        contentInfo.file = file = new File(realFilePath);
        contentInfo.contentPath = contentPath;
        contentInfo.fileName = file.getName();
        contentInfo.length = (int)file.length();
        contentInfo.lastModified = file.lastModified();
        contentInfo.etag = "W/\"" + contentInfo.lastModified + "\"";
        contentInfo.mimeType = this.mimetypesFileTypeMap.getContentType(contentInfo.fileName);
        contentInfo.needGzip = contentInfo.length >= 512 && ArrayUtils.contains((Object[])GZIP_MIME_TYPES, (Object)contentInfo.mimeType);
        return contentInfo;
    }
}

