<%@ tag import="java.util.*" %>
<%@ tag pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ attribute name="page" type="org.springframework.data.domain.Page" required="true"%>
<%@ attribute name="paginationSize" type="java.lang.Integer" required="true"%>
<%
    int current =  page.getNumber() + 1;
    int begin = Math.max(1, current - paginationSize/2);
    int end = Math.min(begin + (paginationSize - 1), page.getTotalPages());
    
    Map<String, String[]> params = request.getParameterMap();  
    String queryString = "";  
    for (String key : params.keySet()) {  
    	if(!"pageNumber".equals(key)){
    		String[] values = params.get(key);  
            for (int i = 0; i < values.length; i++) {  
                String value = values[i];  
                queryString += key + "=" + value + "&";  
            }  
    	}
        
    }
    // 去掉最后一个空格  
    if(queryString.length()>0){
       queryString = queryString.substring(0, queryString.length() - 1); 
    }
    
    request.setAttribute("current", current);
    request.setAttribute("begin", begin);
    request.setAttribute("end", end);
    request.setAttribute("searchParams", queryString);
%>

<% if (page.hasPreviousPage()){%>
<span class="pages_prev" data-handle="pages_prev" pageNumber="${current-1}" onclick="javascript:window.location.href='${ctx}?${searchParams}&pageNumber=${current-1}';">
</span>
<%}else{%>
<span class="pages_prev"></span>
<%} %>

<c:forEach var="i" begin="${begin}" end="${end}">
      <c:choose>
          <c:when test="${i == current}">
              <span class="current">${i}</span>
          </c:when>
          <c:otherwise>
              <a  data-handle="pages_middle" pageNumber="${i}" href="javascript:void(0)" onclick="javascript:window.location.href='${ctx}?${searchParams}&pageNumber=${i}';">${i}</a>
          </c:otherwise>
      </c:choose>
</c:forEach>

 <% if (page.hasNextPage()){%>
 <span class="pages_next"  data-handle="pages_next" pageNumber="${current+1}" onclick="javascript:window.location.href='${ctx}?${searchParams}&pageNumber=${current+1}';">
 </span>
 <%}else{%>
 <span class="pages_next"></span>
 <%} %>