<%@ tag import="com.rocoinfo.utils.QueryStringUtils" %>
<%@ tag import="java.util.*" %>
<%@tag pageEncoding="UTF-8"%>
<%@ attribute name="page" type="org.springframework.data.domain.Page" required="true"%>
<%@ attribute name="paginationSize" type="java.lang.Integer" required="true"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<%
    int current =  page.getNumber() + 1;
    int begin = Math.max(1, current - paginationSize/2);
    int end = Math.min(begin + (paginationSize - 1), page.getTotalPages());
   
    Map<String, String[]> params = request.getParameterMap();  
    String queryString = "";  
    for (String key : params.keySet()) {  
    	if(!"pageNumber".equals(key)){
    		String[] values = params.get(key);  
            for (int i = 0; i < values.length; i++) {  
                String value = values[i];  
                queryString += key + "=" + value + "&";  
            }  
    	}
        
    }  
    // 去掉最后一个空格  
    if(queryString.length()>0){
       queryString = queryString.substring(0, queryString.length() - 1); 
    }
    request.setAttribute("current", current);
    request.setAttribute("begin", begin);
    request.setAttribute("end", end);
    request.setAttribute("searchParams", queryString);
%>

<% if (page.hasPreviousPage()){%>
<a href="javascript:void(0)" class="page_prev" onclick="javascript:window.location.href='${ctx}?${searchParams}&pageNumber=${current-1}';"></a> 
<%}else{%>
<a href="javascript:void(0)" class="page_prev"></a>
<%} %>

 <span class="page_num"><i class="page_current"> <c:if test="${page.totalPages==0}">0</c:if><c:if test="${page.totalPages!=0}">${page.number+1}</c:if></i>/${page.totalPages }</span>

 <% if (page.hasNextPage()){%>
  <a href="javascript:void(0)" class="page_next" onclick="javascript:window.location.href='${ctx}?${searchParams}&pageNumber=${current+1}';"></a>
 <%}else{%>
  <a href="javascript:void(0)" class="page_next"></a>
 <%} %>

