<%@ tag import="com.rocoinfo.utils.QueryStringUtils" %>
<%@tag pageEncoding="UTF-8"%>
<%@ attribute name="page" type="org.springframework.data.domain.Page" required="true"%>
<%@ attribute name="paginationSize" type="java.lang.Integer" required="true"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<%
int current =  page.getNumber() + 1;
int begin = Math.max(1, current - paginationSize/2);
int end = Math.min(begin + (paginationSize - 1), page.getTotalPages());
String searchParams = QueryStringUtils.removePageNumber(request.getQueryString());

request.setAttribute("current", current);
request.setAttribute("begin", begin);
request.setAttribute("end", end);
request.setAttribute("searchParams", searchParams);
%>

<div class="pages <c:if test="${fn:contains(pageContext.request.servletPath,'/customer')}">fr</c:if>" >
	<ul>
		 <% if (page.hasPreviousPage()){%>
               	<a href="?pageNumber=${current-1}&${searchParams}"><span class="pages_prev">&lt;</span></a>
         <%}else{%>
                <span class="pages_prev"><</span>
         <%} %>
 
		<c:forEach var="i" begin="${begin}" end="${end}">
            <c:choose>
                <c:when test="${i == current}">
                    <span class="current">${i}</span>
                </c:when>
                <c:otherwise>
                    <a href="?pageNumber=${i}&${searchParams}">${i}</a>
                </c:otherwise>
            </c:choose>
        </c:forEach>
	  
	  	 <% if (page.hasNextPage()){%>
                <a href="?pageNumber=${current+1}&${searchParams}"><span class="pages_next">&gt;</span></a>
         <%}else{%>
                <span class="pages_next">></span>
         <%} %>

	</ul>
</div>

