<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>
<title>广告管理</title>

<head>
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/sweetalert/sweetalert.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/js/plugins/layer/skin/layer.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/colorpicker/css/bootstrap-colorpicker.min.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/layer/laydate/laydate.js"></script>
    <link href="${ctx}/static/css/upload.css" rel="stylesheet">
</head>

<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="${ctx}/admin/index">主页</a>
            </li>
            <li>
                <strong>广告管理</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <input type="text" name="keyword" placeholder="标题/广告语" class="form-control"/>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <select id="searchTypes" name="type" placeholder="选择类型" class="form-control">
                                        <option value="">全部类型</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket" type="submit" alt="搜索"
                                            title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-7 text-right">
                                <a id="createBtn" data-handle="createModel" class="btn btn-outline btn-primary">添加</a>
                                <div id="advModal" class="modal inmodal" tabindex="-1" role="dialog" aria-hidden="true">
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="row">

                    </div>
                    <table id="advDataTable" width="100%" class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>


<script src="${ctx}/static/js/lib/tmpHogan.js"></script>
<script src="${ctx}/static/js/lib/confirm.modal.js"></script>
<script src="${ctx}/static/hplus/js/plugins/sweetalert/sweetalert.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/colorpicker/bootstrap-colorpicker.min.js"></script>
<script src="${ctx}/static/js/lib/jquery.ui.widget.js"></script>
<script src="${ctx}/static/js/lib/jquery.fileupload.js"></script>
<script src="${ctx}/static/js/lib/jquery.upload.manage.js"></script>
<script src="${ctx}/static/js/upload.js"></script>

<script src="${ctx}/static/js/banners/banners.js"></script>

<script id="hoganTmpl" type="text/mustache">
    {{#modal}}
    <div class="modal-dialog">
      <form>
        <div class="modal-content animated bounceInRight">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
              <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
          </button>
            <h6 class="modal-title">
              {{#adv.id}}编辑广告{{/adv.id}}
              {{^adv.id}}新增广告{{/adv.id}}
          </h6>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label>类型：</label>
              <input id="id" name="id" value="{{adv.id}}" type="hidden">
              <select id="type" name="type" placeholder="选择类型" class="form-control">
                {{#types}}
                  <option {{selected}} value="{{id}}">{{name}}</option>
                {{/types}}
              </select>
            </div>
            <div class="form-group">
              <label>标题：</label>
              <input id="title" name="title" value="{{adv.title}}" type="text" placeholder="标题" required class="form-control" />
            </div>
            <div class="form-group">
              <label>背景颜色：</label>
              <div id="bgColorComponent" class="input-group">
                <input id="bgColor" name="bgColor" value="{{adv.bgColor}}" class="form-control" />
                <span class="input-group-addon"><i></i></span>
                </div>
            </div>
            <div class="form-group">
              <label>广告语：</label>
              <input id="slogan" name="slogan" value="{{adv.slogan}}" type="text" placeholder="广告语" required class="form-control" />
            </div>
            <div class="form-group" id="uploadImg" ></div>
            <div class="form-group">
              <label>图片地址：</label>
              <input id="imgUrl" name="imgUrl" value="{{adv.imgUrl}}" readonly type="text" placeholder="图片地址" required class="form-control" />
            </div>
            <div class="form-group">
              <label>链接地址：</label>
              <input id="linkUrl" name="linkUrl" value="{{adv.linkUrl}}" type="text" placeholder="链接地址" required class="form-control" />
            </div>
            <div class="form-group">
              <label>显示顺序：</label>
              <input id="sortId" name="sortId" value="{{adv.sortId}}" type="text" placeholder="显示顺序" required class="form-control" />
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submit" type="submit" class="btn btn-primary">保存</button>
          </div>
        </div>
      </form>
    </div>
    {{/modal}} 
	{{#editBtn}}
    <button data-handle="adv-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编辑</button>
    <button data-handle="adv-operation" data-id="{{id}}" class="btn {{#isOpenBtn}}btn-primary{{/isOpenBtn}} {{^isOpenBtn}}btn-danger{{/isOpenBtn}} btn-xs" data-status="{{status}}" type="button">{{content}}</button>
    <button data-handle="adv-del" data-id="{{id}}" class="btn btn-danger btn-xs" type="button">删除</button>
	{{/editBtn}}
	{{#typeOptions}}
    {{#types}}
    <option value="{{id}}">{{name}}</option>
    {{/types}}
    {{/typeOptions}}

</script>
</body>