<%@ page contentType="text/html;charset=UTF-8" %>
<title>用户管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <link href="${ctx}/static/css/upload.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="${ctx}/">主页</a>
            </li>
            <li>
                <strong>品牌列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <input id="searchKeyword" name="keyword" type="text"
                                           class="form-control valid" placeholder="中文名称/英文名称">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <select id="searchStatus" name="status" data-placeholder="选择状态"
                                            class="form-control">
                                        <option value="">全部状态</option>
                                        <option value="OPEN" hassubinfo="true">启用</option>
                                        <option value="LOCK" hassubinfo="true">禁用</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                            type="submit" alt="搜索" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-5 text-right">
                                <a id="createBtn" data-handle="createModel"
                                   class="btn btn-outline btn-primary">添加</a>

                                <div id="brandModal" class="modal inmodal" tabindex="-1"
                                     role="dialog" aria-hidden="true">
                                </div>
                            </div>
                        </form>
                    </div>
                    <table id="brandDataTable" width="100%"
                           class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<!-- imgupload -->
<script src="${ctx}/static/js/lib/jquery.ui.widget.js"></script>
<script src="${ctx}/static/js/lib/jquery.fileupload.js"></script>
<script src="${ctx}/static/js/lib/jquery.upload.manage.js"></script>
<script src="${ctx}/static/js/upload.js"></script>

<script src="${ctx}/static/js/brand/brand.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createBrandForm" name="brandForm" action="${ctx}/api/brand/create">
    {{#brand.id}}
        <input type="hidden" name="id" value="{{brand.id}}" />
    {{/brand.id}}
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#brand.name}}编辑品牌{{/brand.name}}{{^brand.name}}添加新品牌{{/brand.name}}</h6>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label>中文名称：</label>
                    <input id="brand_name" name="name" value="{{brand.name}}" type="text"
                        placeholder="品牌中文名称" required class="form-control" />
            </div>

            <div class="form-group">
                <label>英文名称：</label>
                    <input id="brand_englishName" name="englishName" value="{{brand.englishName}}" type="text"
                        placeholder="品牌英文名称" class="form-control" />
            </div>

            <div class="form-group" id="uploadImg" ></div>

            <div class="form-group">
                <input id="brand_imagePath" name="imagePath" value="{{brand.imagePath}}" type="hidden"
                    placeholder="" disabled  class="form-control" />
            </div>

            <div class="form-group">
                <label>排序值：</label>
                    <input id="brand_displayOrder" name="displayOrder" value="{{brand.displayOrder}}" type="text"
                        placeholder="输入排序值" required class="form-control" />
            </div>

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitBrand" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="brand-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编 辑</button>
<button data-handle="brand-operation" data-id="{{id}}" class="btn {{#isOpenClick}} btn-primary{{/isOpenClick}} {{^isOpenClick}}btn-danger{{/isOpenClick}} btn-xs" data-status="{{status}}" type="button">{{content}}</button>
{{/editBtn}}




</script>
</body>

