<%@ page contentType="text/html;charset=UTF-8" %>
<title>分类管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <link rel="stylesheet" href="${ctx}/static/hplus/css/jstree/themes/default/style.min.css"/>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>分类管理列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-12 text-left">
                                <div class="form-group" id="buttons">
                                    <a id="createBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">添加分类</a>
                                    <div class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                    <a id="createClildBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">添加子分类</a>
                                    <div class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                    <a id="editBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">编辑</a>
                                    <div class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="ibox-content">
                        <div class="row">
                            <div class="col-md-5">
                                <div id="jstreeid2"></div>
                            </div>
                            <div class="col-md-7 text-right">
                                <div id="classModal" class="modal inmodal" tabindex="-1"
                                     role="dialog" aria-hidden="true"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/hplus/js/jstree/jstree.min.js"></script>
<script src="${ctx}/static/js/classify/classify.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createForm" name="centUseTypeForm" action="">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <h6 class="modal-title">{{#data.id}}分类管理{{/data.id}}{{^data.id}}添加分类{{/data.id}}</h6>
        </div>
        <div class="modal-body">
				<input id="id" name="id" value="{{data.id}}" type="hidden">
				<input id="parentId" name="parentId" value="{{^data.id}}{{parentId}}{{/data.id}}{{#data.id}}{{data.parentId}}{{/data.id}}" type="hidden">
                <div class="form-group">
                    <label>状态：</label>
                    <select id="status" name="status" required class="form-control">
						<option value='BOTH_VISIBLE'>全部可见</option> 
						<option value='PC_VISIBLE'>仅PC可见</option>
						<option value='APP_VISIBLE'>仅移动App可见</option>
						<option value='INVISIBLE'>都不可见</option>
					</select>
                </div>
				<div class="form-group">
                    <label>编码：</label>
                    <input id="code" name="code" value="{{data.code}}" type="text"
                        class="form-control" placeholder="编码" required />
                </div>
				<div class="form-group">
                    <label>中文名称：</label>
                    <input id="name" name="name" value="{{data.name}}" type="text"
                        class="form-control" placeholder="中文名称" required />
                </div>
				<div class="form-group">
                    <label>排序值：</label>
                    <input id="displayOrder" name="displayOrder" value="{{data.displayOrder}}" type="text"
                        class="form-control" placeholder="排序值" required />
                </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitExpress" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="role-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编 辑</button>
<button data-handle="role-addchild" data-pid="{{id}}" class="btn btn-primary btn-xs" type="button">添加子分类</button>
{{/editBtn}}

</script>
</body>

