<%@ page contentType="text/html;charset=UTF-8" %>
<title>快递公司管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>快递公司列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input id="searchKeyword" name="keyword" type="text"
                                        class="form-control valid" placeholder="编码/名称">
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                        type="submit" alt="搜索" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-7 text-right">
                                <a id="createBtn" data-handle="createModel"
                                    class="btn btn-outline btn-primary">添加</a>
                                <div id="expressModal" class="modal inmodal" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                </div>
                            </div>
                        </form>
                    </div>
                    <table id="expressDataTable" width="100%"
                        class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/express/express.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createExpressForm" name="expressForm" action="${ctx}/api/express/create">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#data.id}}编辑快递公司{{/data.id}}{{^data.id}}添加快递公司{{/data.id}}</h6>
        </div>
        <div class="modal-body">
                <div class="form-group">
                    <label>快递公司编码：</label>
                    <input id="expid" name="id" value="{{data.id}}" type="hidden">
					<input name="status" value="{{#data.id}}{{status}}{{/data.id}}{{^data.id}}OPEN{{/data.id}}" type="hidden">
                    <input id="code" name="code" value="{{data.code}}" type="text"
                            placeholder="编码" required class="form-control" />
                </div>
                <div class="form-group">
                    <label>快递公司名称：</label>
                    <input id="name" name="name" value="{{data.name}}" type="text"
                        class="form-control" placeholder="中文名称" required />
                </div>
                <div class="form-group">
                    <label>官网地址：</label>
                    <input id="homeUrl" name="homeUrl" value="{{data.homeUrl}}" type="text"
                        placeholder="官网地址" required class="form-control" />
                </div>
                <div class="form-group">
                    <label>物流查询地址：</label>
                    <input id="logisticUrl" name="logisticUrl" value="{{data.logisticUrl}}" type="text"
                        placeholder="物流查询地址" required class="form-control" />
                </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitExpress" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="role-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编 辑</button>
<button data-handle="role-operation" data-id="{{id}}" class="btn btn-primary btn-xs" data-status="{{status}}" type="button">{{content}}</button>
<button data-handle="role-city" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">添加城市</button>
{{/editBtn}}
</script>
</body>

