<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/public/taglib.jspf" %>

<title>快递费用模板</title>
<head>
<link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
<link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
<link href="${ctx}/static/hplus/js/plugins/layer/skin/layer.css" rel="stylesheet" />
<link href="${ctx}/static/hplus/css/plugins/summernote/summernote.css" rel="stylesheet">
<link href="${ctx}/static/hplus/css/plugins/summernote/summernote-bs3.css" rel="stylesheet">
<link href="${ctx}/static/hplus/css/animate.css" rel="stylesheet">
<link href="${ctx}/static/hplus/css/style.css?v=2.2.0" rel="stylesheet">
<script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
<script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
<script src="${ctx}/static/hplus/js/plugins/layer/laydate/laydate.js"></script>
<script src="${ctx}/static/hplus/js/plugins/summernote/summernote.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/summernote/summernote-zh-CN.js"></script>
<style>
	table tr td {
		padding: 0px 0px 10px 0px;
	}
	#autoAttr table tr td {
		padding: 0px;
		margin: 0px;
	}
	.bl {
		border-left: 1px solid #000000;
	}
	.br {
		border-right: 1px solid #000000;
	}
	.bt {
		border-top: 1px solid #000000;
	}
	.bo {
		border-bottom: 1px solid #000000;
	}
	.min30 {
		min-width: 30px;
	}
</style>
</head>
<body>
	<div class="row wrapper border-bottom white-bg page-heading">
		<div class="col-lg-10">
			<ol class="breadcrumb">
				<li><a href="/">主页</a></li>
				<li><strong>创建快递费用模板</strong></li>
			</ol>
		</div>
		<div class="col-lg-2"></div>
	</div>
	<div class="wrapper wrapper-content animated fadeInRight">
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content"> 
						<form id="feeTemplateForm" method="post" class="form-horizontal">
							<input type="hidden" id="templateId" name="id" value="0"/>
							<div class="form-group">
								<label class="col-sm-2 control-label">模板名称：</label>
								<div class="col-md-5">
									<input  name="name" type="text" placeholder="模板名称" class="form-control valid" required>									
								</div>
								<div class="col-md-5"> <span style=" display: inline-block; padding-top: 7px;">(模板名称在60字以内)</span> </div>
							</div>
							
							<div class="form-group">
								<label class="col-sm-2 control-label">选择快递公司：</label>
								<div class="col-md-5">
									<select name="express.id" id="expressId" init-id="0" class="form-control">
									</select>								
								</div>
							</div>
							
							<div class=" form-group">
								<label class="col-sm-2 control-label">默认运费：</label>
								<div class="col-md-2" style="width: 100px;">
									<input  name="def.initQuantity" class="form-control" type="text"  required value="" />																
								</div>		
								<span class=" control-label pull-left" > 件内,</span>						
								<div class="col-md-2" style="width: 100px;">
									<input  name="def.initAmt" class="form-control" type="text"  required value="" /> 						
								</div>
								<span class=" control-label pull-left" > 元, &nbsp; &nbsp;</span>		
								<span class=" control-label pull-left" > 每增加 </span>
								<div class=" col-md-2" style="width: 100px;">
									<input name="def.incrUnit" class="form-control" type="text"  required value="" />					
								</div>
								<span class=" control-label pull-left" > 件, &nbsp; &nbsp;</span>
								<span class=" control-label pull-left" > 增加运费</span>
								<div class="col-md-2" style="width: 100px;">
										<input name="def.incrAmt" class="form-control" type="text"  required value="" />  					
								</div>
								<span class=" control-label pull-left" > 元</span>
							</div>
							
							<div class="form-group">
								<label class="col-sm-2 control-label">计费方式：</label>
								  <div class="col-md-10">
									<label for="calcWay_A">
										<input id="calcWayRadioA"  class="radio i-checks" type="radio"  name="calcWay" value="A" checked="checked"/>
										<span title="按件数">按件数</span>
									</label> 			
									<label for="calcWay_KG" class="m-l">
										<input id="calcWayRadioKG" class="radio i-checks" type="radio"  name="calcWay" value="KG">
										<span title="按重量">按重量</span> 
									</label>
									<label for="calcWay_M3" class="m-l">
										<input id="calcWayRadioM3" class="radio i-checks" type="radio"  name="calcWay" value="M3">
										<span title="按体积">按体积</span>
									</label>								
								</div>
							</div>
							
							<div class="form-group">
								<label class="col-sm-2 control-label">城市费用：</label>
								<div class="col-md-10">
									<table id='feeTable' border="1" class="table table-bordered " >
										<thead>
											<tr>
												<th class="text-center" style=" width: 260px ">运送到</th>
												<th class="text-center">首件(件)</th>
												<th class="text-center">首费(元)</th>
												<th class="text-center">续件(件)</th>
												<th class="text-center">续费(元)</th>
												<th class="text-center">操作</th>
											</tr>
										</thead>
										<tbody id='tbody' init-rowIndex="-1">
											<tr>
												<td colspan="6">
													<div class="m-b" style="display:none" id="op1">
														<input id="checkAll" type="checkbox" value="">全选
														<a href="javascript:void(0);" id="batchSetUp"  class="m-r">批量设置</a>    
														<a href="javascript:void(0);" id="batchDel"   class="m-r">批量删除</a>
														<a href="javascript:void(0);" id='batchCancel' class="m-r">取消</a>
													</div>
													<div class="m-b" id="op2">
														<a href="javascript:void(0);" id="addNewFee" class="m-r">为指定地区城市设置运费 </a>   
														<a href="javascript:void(0);" id="batchOperation" class="m-r">批量操作</a> 
													</div>
												</td>
											</tr>
										</tbody>
									</table>								
								</div>
							</div>
							
							<div class="form-group">
								<label class="col-sm-2 control-label"></label>
								<div class="col-md-10">
									<button id="submitTemplate" type="button" class="btn btn-primary">保存模板</button>
									<button id='closeWin' type="button" class="btn btn-white" data-dismiss="modal">返回</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- myModal -->	
	<div class="modal inmodal fade" id="cityModel" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-lg" >
			<div class="modal-content animated bounceInRight">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">关闭</span></button>
					<h4 class="modal-title">选择区域</h4>
				</div>
				<div class="modal-body">
					<div>
						<table class="table">
						<c:forEach var="prov" items="${provCityList}" varStatus="status">
				         <c:if test="${(status.index %3) eq 0}"> <tr> </c:if>												    
						    <td>
									<div class="input-group">
										<div class="form-control"  style="font-size: 12px; padding: 6px 0 6px 2px;"> 
											<input id="prov_chkbox_${prov.id}" type="checkbox"  data-id="${prov.id}" value="${prov.id}" checkboxType="prov"  cityNum="${fn:length(prov.childNodes)}"/> <label id="provNameLabel${prov.id}">${prov.name}</label> <span id="prov_${prov.id}CheckedItems" style="color:red"></span>
										</div>
										<div class="input-group-btn">
											<button  class="btn btn-white dropdown-toggle" type="button" ><span class="caret"></span></button>
											<div id="divCityList_${prov.id}"   class="dropdown-menu pull-right" style="width:440px; padding: 15px 0 0 15px;">
												<c:forEach var="city" items="${prov.childNodes}" varStatus="subStatus">
												   <c:if test="${(subStatus.index % 4) ==0}"> <div class="m-b"> </c:if>
												   <span class="m-r"><input id="city_chkbox_${city.id}" type="checkbox"  value="${city.id}" checkboxType="city" parent="${prov.id}" /> <label id="cityNameLabel${city.id}">${city.name}</label></span> 
									                <c:if test="${((subStatus.index+1) % 4) ==0  || subStatus.last}">  </div> </c:if>
												</c:forEach>
											</div>
										</div>
									</div>
								</td>
						    <c:if test="${((status.index+1) %3) eq 0  || status.last}"> </tr> </c:if>
						</c:forEach>	
						</table>
					</div>
					
				</div>
				<div class="modal-footer">
					<button id="closeProvCityWinBtn"  type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
					<button id="saveProvCitybtn" type="button" class="btn btn-primary">保存</button>
				</div>
			</div>
		</div>
	</div><!-- end myModal -->	
	
	<!-- freightModel -->	
	<div class="modal inmodal fade" id="freightModel" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-lg" >
			<div class="modal-content animated bounceInRight">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">关闭</span></button>
					<h4 class="modal-title">批量设置运费模板</h4>
				</div>
				<div class="modal-body">
					<div class="m-b">
						<label class="control-label pull-left">默认运费：</label>
						<input id='A_' type="text" style="width: 50px;"/> 件内,
						<input id='A_Rmb' type="text" style="width: 50px; "/> 元, 每增加 
						<input id='A_Add' type="text" style="width: 50px;"/> 件, 增加运费
						<input id='A_Add_Rmb' type="text" style="width: 50px; "/> 元 &nbsp;&nbsp;
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" id='batchSetupOk'>确定</button>
					<button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
				</div>
			</div>
		</div>
	</div><!-- end freightModel -->	
	
	<script src="${ctx}/static/js/lib/tmpHogan.js"></script>
	<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
	<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
	<script src="${ctx}/static/js/lib/jquery.ui.widget.js"></script>
	<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
	<script src="${ctx}/static/js/lib/unifyclassfy.modal.js"></script>
	<script src="${ctx}/static/js/express/expressTemplate.js"></script>
	<script src="${ctx}/static/js/express/Map.js"></script>
	<script id="hoganTmpl" type="text/mustache">
	</script>
	<script type="text/javascript">
		$(function(){
			$(".dropdown-toggle").click(function(){
				$(".input-group-btn").removeClass("open");
				if( $(this).parent().hasClass("open")){
						$(".input-group-btn").removeClass("open");
				}else{
					$(this).parent().addClass("open");	
				}	
				
			});
			$(".dropdown-menu").mouseleave(function(){
				$(".input-group-btn").removeClass("open");
			});
		});
	</script>
</body>