<%@ page contentType="text/html;charset=UTF-8" %>
<title>订单管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/layer/laydate/laydate.js"></script>
    <link href="${ctx}/static/hplus/js/plugins/layer/skin/layer.css" rel="stylesheet">
    <link href="${ctx}/static/css/upload.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/sweetalert/sweetalert.css" rel="stylesheet">
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>订单列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <input id="keyword" name="keyword" type="text"
                                        class="form-control valid" placeholder="会员名/订单号/会员手机号">
                                </div>
                                <input type="hidden" name="group" value="" />
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <input type="text" id="startDate" name="startDate" value="${endDate }"
                                               class="laydate-icon form-control layer-date" placeholder="下单日期起">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                	<input type="text" id="endDate" name="endDate" value="${endDate }"
                                               class="laydate-icon form-control layer-date" placeholder="下单日期止">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <select id="supplierId" name="supplierId"  class="form-control">
                                        <option value="">选择供应商</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
	                            <div class="form-group">
	                                <select id="status" name="status" class="form-control">
	                                    <option value="">选择订单状态</option>
	                                    <option value="NOT_PAID">待支付</option>
	                                    <option value="PAID">支付成功</option>
	                                    <option value="RECEIVING">待收货</option>
	                                    <option value="FINISH">已完成</option>
	                                    <option value="CANCELED">已取消</option>
	                                    <option value="REFUND_ACCEPT">退货待受理</option>
	                                    <option value="REFUNDING">退货中</option>
	                                    <option value="REFUNDED">已换货</option>
	                                </select>
	                            </div>
	                        </div>
                            <div class="col-md-1 text-right">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                        type="submit" alt="搜索" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                       
                    </div>
                    <div class="row">
                    	<div class="col-md-3">
	                            <div class="form-group">
	                                <select id="status" name="admStatus" class="form-control">
	                                    <option value="">选择内部订单状态</option>
	                                    <option value="NOT_PAID">部分支付</option>
	                                    <option value="PART_PAID">已处理</option>
	                                    <option value="PAID">支付成功</option>
	                                    <option value="EXCEPTION">异常</option>
	                                    <option value="LOCKED">异常锁定</option>
	                                    <option value="DISTRIBUTED">已生成配送单</option>
	                                    <option value="DISTRIBUTION_MERGED">配送单已合并</option>
	                                    <option value="DISTRIBUTION_WAIT_OUT">配送单待出库</option>
	                                    <option value="DISTRIBUTION_OUTED">配送单已出库</option>
	                                    <option value="DELIVERED">配送单配送中</option>
	                                    <option value="FINISH">已完成</option>
	                                    <option value="CANCELED">已取消</option>
	                                    <option value="REFUND_ACCEPT">退货待受理</option>
	                                    <option value="REFUND_INSTORE">退货已生成入库单</option>
	                                    <option value="REFUND_LOGISTED">退货已输入物流单号</option>
	                                    <option value="REFUND_RECEIVED">退货已确认收货</option>
	                                    <option value="REFUNDED">已退货</option>
	                                </select>
	                            </div>
	                        </div>
                    </div>
                     </form>
                    <div class="row">
                        <div class="col-md-3 ">
                            <div class="form-group">
                                <a id="exportBtn" data-handle="createModel"
                                    class="btn btn-outline btn-primary">导出订单</a>
                            </div>
                        </div>
                        <div class="col-md-9 text-right">
                            <div class="form-group" id="buttons">
								<button class="btn btn-primary btn-xs active" data-group=""    type="button">全部 </button>
								<button class="btn btn-white btn-xs active"  data-group="MATERIAL" type="button">实物订单</button>
								<button class="btn btn-white btn-xs active"  data-group="CRADPWD"    type="button">卡密订单</button>
								<button class="btn btn-white btn-xs active"  data-group="EXCHANGE"    type="button">兑换订单</button>
							</div>
                        </div>
                    </div>
                    <table id="orderDataTable" width="100%"
                        class="table table-striped table-bordered table-hover">
                    </table>
                    <div id="orderModal" class="modal inmodal" tabindex="-1"
                        role="dialog" aria-hidden="true">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>


<script src="${ctx}/static/hplus/js/plugins/sweetalert/sweetalert.min.js"></script>
<script src="${ctx}/static/js/lib/jquery.ui.widget.js"></script>
<script src="${ctx}/static/js/lib/jquery.fileupload.js"></script>
<script src="${ctx}/static/js/lib/jquery.upload.manage.js"></script>
<script src="${ctx}/static/js/upload.js"></script>
<script src="${ctx}/static/js/lib/excel.import.tip.js"></script>
<script src="${ctx}/static/js/order/order.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#OrderSend}}
<div class="modal-dialog">
	<input type="hidden" id="selectExpress" value="{{data.orderItem.express.id}}">
	<input type="hidden" id="orderItemStatus" value="{{data.orderItem.status}}">
	<input type="hidden" id="orderItemTransportNo" value="{{data.orderItem.transportNo}}">
	<input type="hidden" id="orderItemexpressCode" value="{{data.orderItem.express.code}}">
    <form id="saveRealOrder" name="saveRealOrder" action="${ctx}/api/order/create">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title text-left">订单信息</h6>
			<input id="id" name="id" value="{{data.orderItem.id}}" type="hidden">
			<input id="status" name="status" value="{{data.orderItem.status}}" type="hidden">
        </div>
		<div class="modal-body">
			<div class="ibox ">
				<div class="ibox-title">
					<h5>订单信息</h5>
				</div>
				<div class="ibox-content">
					<div class="row">
						<div class="form-group col-sm-6 ">
							<label >订单编号：</label>
							{{data.orderItem.orderCode}}
                		</div>
						<div class="form-group col-sm-6 ">
                    		<label >会员账号：</label>
							{{data.orderItem.order.user.username}}
                		</div>	
					</div>
					<div class="row">
						<div class="form-group col-sm-6 ">
                    		<label >订单状态：</label>
							{{orderStatus}}
                		</div>
						<div class="form-group col-sm-6 ">
                    		<label >订单内部状态：</label>
							{{admStatus}}
                		</div>
					</div>
                    <div class="row">
						<div class="form-group col-sm-6 ">
                    		<label >订单合计：</label>
							{{orderTotal}}
                		</div>	
						<div class="form-group col-sm-6 ">
                    		<label >支付方式：</label>
							{{payType}}
                		</div>

					</div>
					<div class="row">
						<div class="form-group col-sm-6 ">
                    		<label >订单类型：</label>
							{{orderType}}
                		</div>	
						<div class="form-group col-sm-6 ">
                    		<label >商品编号：</label>
							{{data.orderItem.sku.code}}
                		</div>
	
					</div>
					<div class="row">
						<div class="form-group col-sm-6 ">
                    		<label >供应商名：</label>
							{{data.orderItem.sku.product.supplier.name}}
                		</div>
						<div class="form-group col-sm-6 ">
                    		<label >下单单价：</label>
							{{data.orderItem.cent}}分
                		</div>
					</div>
					<div class="row">
						<div class="form-group col-sm-6 ">
                    		<label >积分单价：</label>
							{{data.orderItem.cent}}分
                		</div>	
						<div class="form-group col-sm-6 ">
                    		<label >现金单价：</label>
							{{data.orderItem.price}}元
                		</div>
					</div>
					<div class="row">
						<div class="form-group col-sm-6 ">
                    		<label >购买数量：</label>
							{{data.orderItem.quantity}}
                		</div>	
						<div class="form-group col-sm-6 ">
                    		<label >下单时间：</label>
							{{data.orderItem.createTime}}
                		</div>
					</div>
					<div class='row'>
						<div class="form-group col-sm-6 ">
                    		<label >发票信息：</label>
                		</div>
					</div>
					<div class="row">
						<div class="form-group col-sm-12 ">
                    		<label >商品名称：</label>
							{{data.orderItem.productName}}
                		</div>
					</div>					
				</div>
			</div>
			{{#common}}
			<div class="form-group">
				<label>物流公司：</label>
				<select id="express_id" data-handle="expressid" name="express.id" class="form-control">
				
				</select>
            </div>
			<div class="form-group">
                <label>物流单号：</label>
                <input id="transportNo" name="transportNo" value="{{data.orderItem.transportNo}}" type="text"
                        class="form-control" placeholder="物流单号" required />
            </div>
			{{/common}}
			{{#visual}}
			<div class="form-group">
				<label>虚拟商品类型：</label>
				<select id="vptype" name="vptype" class="form-control">
					<option value="CRADPWD">卡密类</option>
					<option value="RECHARGE">充值类</option>
				</select>
            </div>
			{{/visual}}
			{{#isShow}}
			<div class="ibox ">
				<div class="ibox-title">
					<h5>物流信息</h5>
				</div>
				<div class="ibox-content">
					<div class="row">
						<div class="form-group col-sm-6 ">
							<label >物流公司：</label>
							{{data.orderItem.express.name}}
                		</div>
						<div class="form-group col-sm-6 ">
                    		<label >物流单号：</label>
							{{data.orderItem.transportNo}}
                		</div>	
					</div>
					<div class="row">
						<div class="form-group col-sm-12 ">
							<label>快递信息查询：</label>
							<div id='expressInfo'>

							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="ibox ">
				<div class="ibox-title">
					<h5>收货人信息</h5>
				</div>
				<div class="ibox-content">
					<div class="row">
						<div class="form-group col-sm-4 ">
							<label >收货人：</label>
							{{data.orderItem.order.user.username}}
                		</div>
						<div class="form-group col-sm-4 ">
                    		<label >手机号：</label>
							{{data.orderItem.order.user.mobilePhone}}
                		</div>
						<div class="form-group col-sm-4 ">
                    		<label >邮政编号：</label>
                		</div>
					</div>
					<div class="row">
						<div class="form-group col-sm-12 ">
							<label >收获地址：</label>
                		</div>
					</div>
				</div>
			</div>
			<div class="ibox ">
				<div class="ibox-title">
					<h5>备注信息</h5>
				</div>
				<div class="ibox-content">
					<div class="row">
						<div class="form-group col-sm-12 ">
							
                		</div>
					</div>
				</div>
			</div>
			<div class="ibox ">
				<div class="ibox-title">
					<h5>操作日志</h5>
				</div>
				<div class="ibox-content">
					<div class="row">
						<div class="form-group col-sm-12 ">
							<table class="table table-bordered">
								<thead>
									<tr>
										<th>序号</th>
										<th>操作</th>
										<th>操作人</th>
										<th>操作时间</th>
									</tr>
								</thead>
								<tbody>
								{{#data.operationLogs}}
									<tr>
										<td>{{index}}</td>
										<td>{{operation}}</td>
										<td>{{operator.name}}</td>
										<td>{{logTime}}</td>
									</tr>
								{{/data.operationLogs}}
								</tbody>
							</table>
                		</div>
					</div>
				</div>
			</div>
			{{/isShow}}
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitOrder" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/OrderSend}}
{{#ImportModal}}
<div class="modal-dialog">
	<form>
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">导入模板</h6>
			<input id="filePath" name="filePath" type="hidden" value="" />
			<input id="type" name="type" type="hidden" value="ORDER_IMPORT" />
        </div>
        <div class="modal-body">
               <div class="form-group" id="fileImage"></div>
        </div>
        <div class="modal-footer">
            <button id="downLoadModal" type="button"  class="btn btn-primary">下载模板</button>
            <button id="importModal1" type="button"  class="btn btn-primary">导入</button>
			<button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
        </div>
    </div>
	</form>
</div>
{{/ImportModal}}
{{#PAID}}
<button data-handle="cancel" data-id="{{id}}"  class="btn btn-primary btn-xs" type="button">取消</button>
<button data-handle="handle" data-id="{{id}}"  class="btn btn-primary btn-xs" type="button">处理</button>
{{/PAID}}
{{#DEALED}}
<button data-handle="deliver-goods" data-id="{{id}}" data-type="{{orderType}}"  class="btn btn-primary btn-xs" type="button">发货</button>
{{/DEALED}}
{{#SENDING}}
<button data-handle="confirm-receipt" data-id="{{id}}" data-type="{{orderType}}" class="btn btn-primary btn-xs" type="button">确认收货</button>
{{#common}}
<button data-handle="edit-logistics" data-id="{{id}}" data-type="{{orderType}}" class="btn btn-primary btn-xs" type="button">修改物流</button>
{{/common}}
{{#visual}}
<button data-handle="delivergoods-again" data-id="{{id}}" data-type="{{orderType}}" class="btn btn-primary btn-xs" type="button">重新发货</button>
{{/visual}}
{{/SENDING}}
</script>
</body>

