<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>
<title>保险分类管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <!--<link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">-->
    <link href="${ctx}/static/hplus/css/plugins/sweetalert/sweetalert.css" rel="stylesheet">
    <!--<script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>-->
    <!--<script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>-->
    <script src="${ctx}/static/hplus/js/plugins/layer/laydate/laydate.js"></script>
    <link href="${ctx}/static/hplus/js/plugins/layer/skin/layer.css" rel="stylesheet">
    <link rel="stylesheet" href="${ctx}/static/hplus/css/jstree/themes/default/style.min.css"/>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>分类管理列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-12 text-left">
                                <div class="form-group" id="buttons">
                                    <a id="createBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">添加</a>
                                    <div class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                    <a id="editBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">编辑</a>
                                    <div class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                    <a id="deleteBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">删除</a>
                                    <div class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="ibox-content">
                        <div class="row">
                            <div class="col-md-5">
                                <div id="jstree"></div>
                            </div>
                            <div class="col-md-7 text-right">
                                <div id="modal" class="modal inmodal" tabindex="-1"
                                     role="dialog" aria-hidden="true"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>

<script src="${ctx}/static/hplus/js/plugins/sweetalert/sweetalert.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/jsTree/jstree.min.js"></script>
<script src="${ctx}/static/js/product/category.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form>
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#category.id}}编辑保险分类{{/category.id}}{{^category.id}}新增保险分类{{/category.id}}</h6>
        </div>
        <input type="hidden" name="parentId" value="{{parentId}}">
        <div class="modal-body">
          <div class="form-group">
              <label>分类名称：</label>
              <input id="id" name="id" value="{{category.id}}" type="hidden">
              <input id="name" name="name" value="{{category.name}}" type="text"
                      placeholder="分类名称" required class="form-control" />
          </div>
          <div class="form-group">
              <label>分类编码：</label>
              <input id="code" name="code" value="{{category.code}}" type="text"
                      placeholder="分类编码" required class="form-control" />
          </div>
          <div class="form-group">
            <label>选择分类：</label>
            <select id="status" name="status" placeholder="显示位置"
                    class="form-control">
                {{#displayPositions}}
                <option {{selected}} value="{{id}}">{{name}}</option>
                {{/displayPositions}}
            </select>
          </div>
          <div class="form-group">
              <label>排序值：</label>
              <input id="displayOrder" name="displayOrder" value="{{category.displayOrder}}" type="text"
                      placeholder="排序值" required class="form-control" />
          </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitBtn" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}



</script>
</body>

