<%@ page contentType="text/html;charset=UTF-8" %>
<title>商品管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/js/plugins/layer/skin/layer.css" rel="stylesheet"/>
    <link href="${ctx}/static/hplus/css/plugins/summernote/summernote.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/summernote/summernote-bs3.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/animate.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/style.css?v=2.2.0" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/layer/laydate/laydate.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/summernote/summernote.min.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/summernote/summernote-zh-CN.js"></script>
    <style>
        .property_value li {
            width: 100%;
        }

        .nav-info > li > a {
            color: gray !important;
        }

        .nav-info > li.active > a {
            color: #000 !important;
        }
    </style>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="${ctx}/">主页</a>
            </li>
            <li>
                <strong>商品管理</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input id="searchKeyword" name="keyword" type="text" class="form-control valid"
                                           placeholder="sku编码/商品名称/显示名称/分类/供应商">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <select id="searchVisual" name="isVisual" class="form-control">
                                        <option value="">是否虚拟</option>
                                        <option value="true">是</option>
                                        <option value="false">否</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                            type="submit" alt="搜索" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-5  text-right">
                                <div class="form-group">
                                    <a id="createBtn" data-handle="createModel"
                                       class="btn btn-outline btn-primary">添加</a>

                                    <div id="skuModal" class="modal inmodal" tabindex="-1"
                                         role="dialog" aria-hidden="true">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="row">
                        <div class="col-md-12 text-right" id="types">

                        </div>
                    </div>
                    <table id="productDataTable" width="100%"
                           class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="skuDetailModal" class="modal inmodal" tabindex="-1" role="dialog" aria-hidden="true"></div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/product/product.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createSkuForm" name="skuForm" action="${ctx}/api/rank/save">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">新增商品</h6>
        </div>
        <div class="modal-body" style="overflow-y: auto; height: 500px;">
			<div class="form-group">
				<label>选择供应商：</label>
				<select name="supplier" class="form-control">
					<option value="">全部供应商</option>
					{{#suppliers}}
						<option value="{{id}}">{{name}}</option>
					{{/suppliers}}
				</select>
			</div>
			<div class="form-group">
				<label>选择品牌：</label>
				<select name="brand" class="form-control">
					<option value="">全部品牌</option>
					{{#brands}}
						<option value="{{id}}">{{name}}</option>
					{{/brands}}
				</select>
			</div>
			<div class="form-group">
				<label>分类ID：</label>
				<input id="catalogs" name="catalogs" type="text" class="form-control" placeholder="分类ID" required />
				<!--
				<select name="type.id" class="form-control">
					<option value="0">全部分类</option>
					{{#classifys}}
						<option value="{{id}}">{{name}}</option>
					{{/classifys}}
				</select>
				-->
			</div>
			<div class="form-group">
				<label>商品名称：</label>
				<input id="productName" name="name" type="text" class="form-control" placeholder="商品名称" required />
			</div>
			<div class="form-group">
				<label>上架时间：</label><br />
				<input id="listTime" name="listTime" class="laydate-icon form-control layer-date" style="max-width:none;" type="text"
                    placeholder="上架时间" required value="" />
			</div>
			<div class="form-group">
				<label>下架时间：</label>
				<input id="delistTime" name="delistTime" class="laydate-icon layer-date form-control" style="max-width:none;" type="text"
                    placeholder="下架时间" required value="" />
			</div>
			<div class="form-group">
				<label>促销语：</label>
				<textarea id="promotion" cols="30" rows="5" name="promotionWord" 
					class="form-control" placeholder="促销语" required></textarea>
			</div>
			<div class="form-group">
				<label>是否打折：</label>
				<select name="supportDiscount" class="form-control">
					<option value="0">否</option>
					<option value="1">是</option>
				</select>
			</div>
			<div class="form-group">
				<label>虚拟商品：</label>
				<select name="visual" class="form-control">
					<option value="0">否</option>
					<option value="1">是</option>
				</select>
			</div>
			<div class="ibox float-e-margins border-bottom">
				<div class="ibox-title">
					<h5>展示类型</h5>
					<div class="ibox-tools">
						<a class="collapse-link">
							<i class="fa fa-chevron-up"></i>
                        </a>
                    </div>
				</div>
				<div class="ibox-content" style="display:none;">
                	<div class="row ">
						<div class="col-md-4 col-xs-4 form-group role-item ellips">
                    		<label for="status_PC_VISIBLE"><input id="status_PC_VISIBLE" type="checkbox" class="i-checks" data-checkbox="sub"
                        		name="showStatus" value="{{PC_VISIBLE}}">
                        		<span title="PC可见">PC可见</span>
							</label>
						</div>
						<div class="col-md-4 col-xs-4 form-group role-item ellips">
	                    	<label for="status_WAP_VISIBLE"><input id="status_WAP_VISIBLE" type="checkbox" class="i-checks" data-checkbox="sub"
    	                    	name="showStatus" value="{{WAP_VISIBLE}}">
								<span title="WAP可见">WAP可见</span>
							</label>
						</div>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label>商品主图：</label>
				<input id="file" name="file" type="text" class="form-control" placeholder="商品主图路径" required />
			</div>
			<div class="btn-group" data-toggle="buttons">
				<label class="btn btn-sm btn-white active">
					<input id="option1" type="radio" name="options">
					商品详情
				</label>
				<label class="btn btn-sm btn-white">
					<input id="option1" type="radio" name="options">
					规格参数
				</label>
				<label class="btn btn-sm btn-white">
					<input id="option1" type="radio" name="options">
					包装清单
				</label>
				<label class="btn btn-sm btn-white">
					<input id="option1" type="radio" name="options">
					售后服务
				</label>
			</div>
			<div id="detailDiv" class="mail-text h-200" style="background-color:#fff;" >
				<div class="summernote" id="t1" style="display:none;">
				</div>
				<div class="clearfix"></div>
			</div>
			<div id="paramDiv" class="mail-text h-200" style="background-color:#fff;display:none;" >
				<div class="summernote" id="t1" style="display:none;">
				</div>
				<div class="clearfix"></div>
			</div>
			<div id="listDiv" class="mail-text h-200" style="background-color:#fff;display:none;" >
				<div class="summernote" id="t1" style="display:none;">
				</div>
				<div class="clearfix"></div>
			</div>
			<div id="warrantyDiv" class="mail-text h-200" style="background-color:#fff;display:none;" >
				<div class="summernote" id="t1" style="display:none;">
				</div>
				<div class="clearfix"></div>
			</div>
			<div class="form-group" id="attr1Div">
				<label>属性1名称：</label>
				<input style="width:30%;display: inline; " id="attr1" name="attr1" type="text" class="form-control" placeholder="属性名称1" required />
				<label>属性1值：</label>
				<input style="width:30%;display: inline; " id="value1" name="value1" type="text" class="form-control" placeholder="属性名称1" required />
				<button data-handle="attr-add1" data-id="1" class="btn btn-primary btn-xs" type="button">增加</button>
				<ul class="clear form-group"></ul>
			</div>
			<div class="form-group" id="attr2Div">
				<label>属性2名称：</label>
				<input style="width:30%;display: inline; " id="attr2" name="attr2" type="text" class="form-control" placeholder="属性名称1" required />
				<label>属性2值：</label>
				<input style="width:30%;display: inline; " id="value2" name="value2" type="text" class="form-control" placeholder="属性名称1" required />
				<button data-handle="attr-add2" data-id="2" class="btn btn-primary btn-xs" type="button">增加</button>
				<ul class="clear property_value"></ul>
			</div>
			<div class="form-group" id="attr3Div">
				<label>属性3名称：</label>
				<input style="width:30%;display: inline; " id="attr3" name="attr3" type="text" class="form-control" placeholder="属性名称1" required />
				<label>属性3值：</label>
				<input style="width:30%;display: inline; " id="value3" name="value3" type="text" class="form-control" placeholder="属性名称1" required />
				<button data-handle="attr-add3" data-id="3" class="btn btn-primary btn-xs" type="button">增加</button>
				<ul class="clear property_value"></ul>
			</div>
			<div class="form-group" id="attrGenerate">
				<button data-handle="attr-generate" class="btn btn-primary btn-xs" type="button">生成</button>
			</div>
			<div class="form-group" id="generateBox">
			</div>
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
			<button id="submitRank" type="submit" class="btn btn-primary">保存</button>
		</div>
	</div>
	</form>
</div>
{{/modal}}
{{#editBtn}}
	{{#edit}}
		<button data-handle="sku-edit" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">编辑</button>
	{{/edit}}
	{{#discard}}
		<button data-handle="sku-discard" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">作废</button>
	{{/discard}}
	{{#submitAudit}}
		<button data-handle="sku-submitAudit" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">提交审批</button>
	{{/submitAudit}}
	{{#auditRefuse}}
		<button data-handle="sku-auditRefuse" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">审批拒绝</button>
	{{/auditRefuse}}
	{{#auditOk}}
		<button data-handle="sku-auditOk" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">审批通过</button>
	{{/auditOk}}
	{{#deList}}
		<button data-handle="sku-deList" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">下架</button>
	{{/deList}}
	{{#list}}
		<button data-handle="sku-list" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">上架</button>
	{{/list}}
	<button data-handle="sku-detail" data-id="{{proId}}" class="btn btn-primary btn-xs" type="button">详情</button>
{{/editBtn}}
{{#types}}
<button data-handle="product-status" data-id="0" data-target="group_btn" class="btn btn-white btn-xs active" type="button">全部</button>
	{{#data}}
		<button data-handle="product-status" data-id="{{id}}" data-target="group_btn" class="btn btn-white btn-xs" type="button">{{name}}</button>
    {{/data}}
{{/types}}
{{#classifys}}
	<option value="0">全部分类</option>
	{{#data}}
		<option value="{{id}}">{{name}}</option>
    {{/data}}
{{/classifys}}
{{#suppliers}}
	<option value="0">全部供应商</option>
	{{#data}}
		<option value="{{id}}">{{name}}</option>
    {{/data}}
{{/suppliers}}
{{#createAttribute}}
<div>
<div style="width:55%;text-align:right;display:inline-block">&nbsp;</div>
<div style="width:40%;display:inline-block">{{val}}</div>
<div class="close" id="close_{{id}}_{{index}}" style="font-size: 17px;">X</div>
</div>
{{/createAttribute}}
{{#createSku}}
<div class="popup-box w85" id="sku_{{index}}" style="border:1px solid black;width:90%">
	<div class="popup-head">
		<div class="fl">
			<label class="fl lh28" >序号：{{index}}&nbsp;&nbsp;&nbsp;&nbsp;</label>
			<label class="fl lh28" >{{sku.attr1.attr}}：{{sku.attr1.val}}&nbsp;&nbsp;&nbsp;&nbsp;</label>
			<label class="fl lh28" >{{sku.attr2.attr}}：{{sku.attr2.val}}&nbsp;&nbsp;&nbsp;&nbsp;</label>
			<label class="fl lh28" >{{sku.attr3.attr}}：{{sku.attr3.val}}&nbsp;&nbsp;&nbsp;&nbsp;</label>
		</div>
	</div>
	<div class="popup-body clearfix">
		<div class="group fl">
			<label class="fl lh28" >供应商编码：</label>
			<input id="skuCode{{index}}" type="text" maxlength="20" class="form-control">
		</div>
		<div class="group fl">
			<label class="fl lh28" >积分：</label>
			<input id="cent{{index}}" type="text" class="form-control">
		</div>
		<div class="group fl">
			<label class="fl lh28" >商品价：</label>
			<input id="skuPrice{{index}}" type="number" class="form-control"   >
			(可保留两位小数)
		</div>
		<div class="group fl">
			<label class="fl lh28" >服务价：</label>
			<input id="servicePrice{{index}}" type="number" class="form-control">
			(可保留两位小数)
		</div>
		<div class="group fl lh28">
			<label for="status_PC_VISIBLE">
                <span title="启用">启用</span>
				<input  id="status{{index}}" type="checkbox" class="i-checks" data-checkbox="sub"
                        name="status" value="{{PC_VISIBLE}}">
			</label>
		</div>
		<div class="group clear">
			<label class="fl lh28" >图片：</label>
			<span class="btn-add btn-upload w70">
				<input type="text" name="file" class="form-control">
			</span>
		</div>
		<div class="clear"></div>
	</div>
</div>
{{/createSku}}
{{#skuDetail}}
<div class="modal-dialog" style="width:1000px;">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">商品详情</h6>
        </div>
        <div class="modal-body" style="overflow-y: auto; height: 500px;">
			<div class="panel blank-panel">
				<div class="panel-heading">
					<div class="panel-options">
						<ul class="nav nav-tabs nav-info">
							<li class="active"><a data-toggle="tab"
								href="tabs_panels.html#tab-1">商品信息</a></li>
							<li class=""><a data-toggle="tab"
								href="tabs_panels.html#tab-2">积分历史</a></li>
							<li class=""><a data-toggle="tab"
								href="tabs_panels.html#tab-3">操作日志</a></li>
							<li class=""><a data-toggle="tab"
								href="tabs_panels.html#tab-4">入库记录</a></li>
							<li class=""><a data-toggle="tab"
								href="tabs_panels.html#tab-5">出库记录</a></li>
						</ul>
					</div>
				</div>
				<div class="panel-body">
					<div class="tab-content">
									
						<div id="tab-1" class="tab-pane active">
							<div class="ibox ">
							<div class="ibox-title">
								<h5>商品信息</h5>
							</div>
							<div class="ibox-content">
								<div class="row">
									<div class="form-group col-sm-4 ">
										<label >商品编码：</label>
										{{sku.code}}
                					</div>
									<div class="form-group col-sm-4 ">
                    					<label >供应商：</label>
										{{supplier.name}}
                					</div>
									<div class="form-group col-sm-4 ">
                    					<label >分类：</label>
										{{catalogs.name}}
                					</div>	
								</div>
								<div class="row">
									<div class="form-group col-sm-4">
										<label >上架时间：</label>
										{{listTime}}
                					</div>
									<div class="form-group col-sm-4">
                    					<label >下架时间：</label>
										{{delistTime}}
                					</div>
								</div>
								<div class="row">
									<div class="form-group col-sm-4">
										<label >商品名称：</label>
										 {{sku.name}}
                					</div>
									<div class="form-group col-sm-4">
                    					<label >会员等级名称：</label>
                					</div>
									<div class="form-group col-sm-4">
                    					<label >支持打折：</label>
										{{#supportDiscount}}是{{/supportDiscount}}{{^supportDiscount}}否{{/supportDiscount}}
                					</div>
								</div>
								<div class="row">
									<div class="form-group col-sm-4">
										<label >虚拟商品：</label>
										{{#visual}}是{{/visual}}{{^visual}}否{{/visual}}
                					</div>
									<div class="form-group col-sm-4">
                    					<label >展示类型：</label>
										{{showStatus}}
                					</div>
									<div class="form-group col-sm-4">
                    					<label >状态：</label>
										 {{status}}
                					</div>
								</div>
								<div class="row">
									<div class="form-group col-sm-12">
										<label >商品主图：</label>
										<img src="{{productImages.imageUrl}}" style="width:100px;height:100px;"/>
                					</div>
								</div>
								<div class="row">
									<div class="form-group col-sm-12">
										<label >促销语：</label>
										{{promotionWord}}
                					</div>
								</div>
							</div>
						</div>
						<div class="ibox ">
							<div class="ibox-title">
								<h5>其他信息</h5>
							</div>
							<div class="ibox-content">
								<div class="row">
									<div class="form-group col-sm-12">
										{{#description.introduction}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#4ba84b;">商品详情</div>
										{{/description.introduction}}
										{{^description.introduction}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#999999;">商品详情</div>
										{{/description.introduction}}
										{{#description.specification}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#4ba84b;">规格参数</div>
										{{/description.specification}}
										{{^description.specification}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#999999;">规格参数</div>
										{{/description.specification}}
										{{#description.packingList}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#4ba84b;">包装清单</div>
										{{/description.packingList}}
										{{^description.packingList}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#999999;">包装清单</div>
										{{/description.packingList}}
										{{#description.afterSale}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#4ba84b;">售后服务</div>
										{{/description.afterSale}}
										{{^description.afterSale}}
											<div style="height: 28px;width: 80px;float: left;line-height: 28px;margin: 2px 10px 2px 0;text-align: center;color:#ffffff;background:#999999;">售后服务</div>
										{{/description.afterSale}}
                					</div>
								</div>
							</div>
						</div>
							<div class="form-group">
								<table id="DetailDataTable" width="100%"
									class="table table-striped table-bordered table-hover">
								</table>
							</div>
							<div class="clearfix"></div>
						</div>
						<div id="tab-2" class="tab-pane">
							<div class="form-group" id="historyBox">
								<table id="historyDataTable" width="100%"
									class="table table-striped table-bordered table-hover">
								</table>
								<div class="clearfix"></div>
							</div>
						</div>
						<div id="tab-3" class="tab-pane">
							<div class="form-group" id="historyBox">
								<table id="opDataTable" width="100%"
									class="table table-striped table-bordered table-hover">
								</table>
								<div class="clearfix"></div>
							</div>
						</div>
						<div id="tab-4" class="tab-pane">
							<div class="form-group" id="historyBox">
								<table id="inStoreTable" width="100%"
									class="table table-striped table-bordered table-hover">
								</table>
								<div class="clearfix"></div>
							</div>
						</div>
						<div id="tab-5" class="tab-pane">
							<div class="form-group" id="historyBox">
								<table id="outStoreTable" width="100%"
									class="table table-striped table-bordered table-hover">
								</table>
								<div class="clearfix"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
		</div>
	</div>
</div>
{{/skuDetail}}

</script>
</body>