<%@ page contentType="text/html;charset=UTF-8" %>
<title>商品SKU模板字典</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>商品SKU模板字典</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                	<div class="small">
	                    <div class="row">
	                        <form id="searchForm">
	                        	<!-- 
	                            <div class="col-md-2">
	                                <div class="form-group">
	                                    <select id="searchStatus" name="status" data-placeholder="选择状态" class="form-control">
	                                        <option value="">全部状态</option>
	                                        <option value="OPEN" hassubinfo="true">启用</option>
	                                        <option value="LOCK" hassubinfo="true">锁定</option>
	                                    </select>
	                                </div>
	                            </div>
	                            <div class="col-md-1">
	                                <div class="form-group">
	                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
	                                        type="submit" alt="搜索" title="搜索">
	                                        <i class="fa fa-search"></i>
	                                    </button>
	                                </div>
	                            </div>
	                             -->
	                            <div class="col-md-12 text-right">
	                                <a id="createBtn" data-handle="createModel"
	                                    class="btn btn-outline btn-primary">添加</a>
	                                <div id="skuTypesModal" class="modal inmodal" tabindex="-1"
	                                    role="dialog" aria-hidden="true">
	                                </div>
	                            </div>
	                        </form>
	                    </div>
	                    <table id="skuTypesDataTable" width="100%"
	                        class="table table-striped table-bordered table-hover">
	                    </table>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/product/skuTypes.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createSkuTypesForm" name="skuTypesForm" action="${ctx}/api/dictskumeta/save">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#skuTypes.id}}编辑商品SKU模板{{/skuTypes.id}}{{^skuTypes.id}}新增商品SKU模板{{/skuTypes.id}}</h6>
        </div>
        <div class="modal-body">
                <div class="form-group">
                    <label>属性名称：</label>
                    <input id="id" name="id" value="{{#skuTypes.id}}{{skuTypes.id}}{{/skuTypes.id}}{{^skuTypes.id}}0{{/skuTypes.id}}" type="hidden">
                    <input id="name" name="name" value="{{skuTypes.name}}" type="text"
                            placeholder="属性名称" required class="form-control" />
                </div>
                <div class="form-group">
                    <label>显示名称：</label>
                    <input id="displayName" name="displayName" value="{{skuTypes.displayName}}" type="text"
                        class="form-control" placeholder="显示名称" required />
                    <input id="propertys" name="propertys" value="{{skuTypes.propertys}}" type="hidden"
                        class="form-control" required />
                </div>
				<div id="attrBox" style="display:{{#skuTypes.id}}block{{/skuTypes.id}}{{^skuTypes.id}}none{{/skuTypes.id}}">
                <div class="form-group">
                    <label>显示内容：</label>
					<hr/>
                </div>
				<div id="attrContent"></div>
				</div>
				<div class="form-group">
					<label>新增属性：
						<button type="button" class="btn btn-white" data-handle="attr-add">添加属性</button>
					</label>
					<input value="" id="attrInfo" type="text" class="form-control" placeholder='属性内容(多个属性请用引文逗号间隔",")' />
				</div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitSkuTypes" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="skuTypes-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编 辑</button>
<button data-handle="skuTypes-delete" data-id="{{id}}" class="btn btn-danger btn-xs" type="button">删除</button>
{{/editBtn}}
{{#showAttrs}}
	{{#attrs}}
		<div class="form-group">
			<label data-handle="attr-delete" data-id="{{attr}}" style="float:right;font-size: 24px;color:red;cursor:pointer;">删除</label>
			<input value="{{attr}}" type="text" class="form-control" style="width:90%;" disabled="" required />
		</div>
	{{/attrs}}
{{/showAttrs}}
</script>
</body>

