<%@ page contentType="text/html;charset=UTF-8" %>
<title>角色管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>角色列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div id="roleModal" class="modal inmodal" tabindex="-1"
                role="dialog" aria-hidden="true">
            </div>
            <!-- <div class="col-xs-12 text-right">
                <button id="createBtn" data-handle="createModel"
                    role="button" class="btn btn-outline btn-primary">添加新角色</button>

            </div> -->
            <!-- <div class="ibox">
                <div class="ibox-title">
                    <h5>角色列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content">
                    <table id="roleDataTable" width="100%"
                        class="table table-striped table-bordered table-hover dataTables-example">
                    </table>
                </div>
            </div> -->
            <div class="ibox">
                <!-- <div class="ibox-title">
                    <h5>角色列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                    </div>
                </div> -->

                <div class="ibox-content">
                    <div class="min">
                    <div class="col-xs-12 text-right">
                        <button id="createBtn" data-handle="createModel"
                            role="button" class="btn btn-outline btn-primary">添加</button>
                    </div>
                    <table id="roleDataTable" width="100%"
                        class="table table-striped table-bordered table-hover">
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>

<script src="${ctx}/static/js/lib/tmpHogan.js"></script>
<script src="${ctx}/static/js/lib/confirm.modal.js"></script>
<script src="${ctx}/static/js/role/role.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createRoleForm" name="roleForm" action="${ctx}/api/role/create">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h4 class="modal-title">{{#role}}编辑角色{{/role}}{{^role}}添加新角色{{/role}}</h4>
        </div>
        <div class="modal-body">
                <div class="form-group">
                    <label>角色名：</label>
                    <input id="id" name="id" value="{{role.id}}" type="hidden">
                    <input id="roleName" name="name" value="{{role.name}}" type="text"
                        placeholder="角色名" required class="form-control">
                </div>
                <div class="form-group">
                    <label>描述：</label>
                    <textarea id="roleDescription" name="description"
                        class="form-control" placeholder="描述">{{role.description}}</textarea>
                </div>
                <hr/>
                <div class="form-group">
                    <label>
                        全选：
                        <input id="selAllCb" type="checkbox" class="i-checks" data-checkbox="all">
                    </label>
                </div>
                {{#permissions}}
                <div class="ibox float-e-margins border-bottom">
                    <div class="ibox-title">
                        <h5>{{getPermissionName}}</h5>
                        <div class="ibox-tools">
                            <a class="collapse-link">
                                <i class="fa fa-chevron-up"></i>
                            </a>
                        </div>
                    </div>
                    <div class="ibox-content" style="display:none;">
                        <div class="row ">
                            {{#value}}
                                <div class="col-md-4 col-xs-4 form-group role-item ellips">
                                    <label title="{{label}}">
                                        <input type="checkbox" {{#hasPermission}}checked{{pushPermission}}{{/hasPermission}}
                                            class="i-checks" data-checkbox="sub"
                                            data-rolename="{{name}}" data-rolevalue="{{permission}}">
                                    {{label}}</label>
                                </div>
                            {{/value}}
                        </div>
                    </div>
                </div>
                {{/permissions}}

                {{#role}}
                <!-- 修改的加入删除按钮 -->
                <div class="form-group">
                    <button id="deleteRole" data-handle="role-delete" data-id="{{id}}"
                        data-role type="button" class="btn btn-primary btn-block">删除角色</button>
                </div>
                {{/role}}
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitRole" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="role-edit" data-id="{{id}}" class="btn btn-xs btn-primary" type="button">编 辑</button>
<button data-handle="list-del" data-id="{{id}}" class="btn btn-danger btn-xs" type="button">删 除</button>
{{/editBtn}}
</script>
</body>

