<%@ page contentType="text/html;charset=UTF-8" %>
<title>库存管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>库存管理</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
			<div class="ibox">
				<div class="ibox-content">
					<form id="searchForm">
                    	<div class="row">
                            <div class="col-md-11">
                                <div class="row">
                                    <div class="col-md-2">
										<div class="form-group">
											<input id="sku_code_name" name="keyword" type="text" placeholder="SKU编码/SKU名称" class="form-control valid" >
		                            	</div>
		                            </div>
                                
                                    <div class="col-md-2">
                                        <div class="form-group">
                                        	<input type="hidden" name="source" value="skuStore">
                                            <select id="sku_status" name="stockStatus" data-placeholder="选择库存状态" class="form-control">
                                                <option value="">库存状态</option>
                                                <option value="NORMAL">正常</option>
                                                <option value="WARNING">预警</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <select id="sku_supplier" name="supplierId" data-placeholder="选择供应商" class="form-control">
                                                <option value="">全部供应商</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                            type="submit" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                           	</div>
                           	<div class="row">
                           		<div id="skuModal" class="modal inmodal" tabindex="-1"
	                                 role="dialog" aria-hidden="true">
								</div>
								<div id="inModal" class="modal inmodal" tabindex="-1"
	                                 role="dialog" aria-hidden="true">
								</div>
							</div>
                    	</div>
                        <%--
                    	<div class="row">
							<!-- <div class="col-md-2">
								<div class="form-group">
									<input id="sku_code_name" name="keyword" type="text" placeholder="SKU编码/SKU名称" class="form-control valid" >
                            	</div>
                            </div> 
                            <div class="col-md-8"></div>-->
							<div class="col-md-2">
								<a id="backBtn" data-handle="backModel" class="btn btn-outline btn-primary">退货确认收货</a>
								<div id="backModel" class="modal inmodal" tabindex="-1" role="dialog" aria-hidden="true"></div>
							</div>
						</div>
						--%>
					</form>
                    <table id="skuDataTable" width="100%"
                           class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/sku/sku.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createBrandForm" name="brandForm" action="${ctx}/api/brand/create">
    {{#sku.id}}
        <input type="hidden" name="id" value="{{sku.id}}" />
    {{/sku.id}}
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{^isVirtual}}设置预警库存{{/isVirtual}}{{#isVirtual}}设置虚拟库存{{/isVirtual}}</h6>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label>SKU编码：</label>
                    <input id="sku_code" name="code" value="{{sku.code}}" type="text"
                        disabled required class="form-control" />
            </div>
            <div class="form-group">
                <label>SKU名称：</label>
                    <input id="sku_name" name="name" value="{{sku.name}}" type="text"
                        disabled required class="form-control" />
            </div>
            <div class="form-group">
				{{^isVirtual}}
					<label>预警库存数量：</label>
					<input id="sku_warningsku" name="warningStock" value="{{sku.warningStock}}" type="text" placeholder="输入预警库存数量" class="form-control" />
				{{/isVirtual}}
				{{#isVirtual}}
					<label>虚拟库存数量：</label>
					<input id="sku_virtual" name="virtualStock" value="{{sku.virtualStock}}" type="number" placeholder="输入虚拟库存数量" class="form-control" />
				{{/isVirtual}}
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitBrand" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="warningsku-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">预警库存</button>
<button data-handle="warningsku-virtual" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">虚拟库存</button>
<button data-handle="warningsku-in" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">采购入库</button>
{{/editBtn}}
{{#isIn}}
<div class="modal-dialog">
    <form id="inForm" action="${ctx}/api/instoreOrder/purchase" method="post">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h4 class="modal-title">采购入库</h4>
        </div>
        <div class="modal-body">
			<div class="form-group">
				<label>SKU名称：</label>
				<input id="sku_name" name="name" value="{{sku.name}}" type="text" disabled required class="form-control" />
            </div>
			<div class="form-group">
				<label>仓库：</label>
				<select name="warehouse.id" class="form-control">
				{{#warehouses}}
					<option value="{{id}}">{{name}}</option>
				{{/warehouses}}
				</select>
			</div>
			<div class="form-group">
				<label>入库说明:</label>
				<textarea id="note" class="form-control" required="" placeholder="请输入入库说明" name="note" aria-required="true">{{data.note}}</textarea>
			</div>
			<div class="form-group">
				<label>入库数量:</label>
				<input type='number' data-num='num' name="quantity" value="{{quantity}}" required min="1">
			</div>
		</div>
		<div class="modal-footer">
			<input type="hidden" name="sku.id" value="{{sku.id}}" />
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitIn" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/isIn}}
{{#backlist}}
<div id="backModalDialog" class="modal-dialog" style="width:807px;heght:600px;">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h4 class="modal-title">退货确认收货</h4>
        </div>
        <div class="modal-body" style="padding: 0px;margin: 0px 5px;">
			<div class="form-group" style="margin-bottom:0px;">
				<table id="backDataTable" width="100%" class="table table-striped table-bordered table-hover"></table>
            </div>
		</div>
		<div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
        </div>
    </div>
</div>
{{/backlist}}
{{#backEditBtn}}
	<button data-handle="sku-back" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">确认收货</button>
{{/backEditBtn}}
</script>
</body>

