<%@ page contentType="text/html;charset=UTF-8" %>
<title>供应商管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>供应商列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <input id="keyword" name="keyword" type="text"
                                        class="form-control valid" placeholder="供应商编码/中文名称">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <select id="useable" name="useable"  class="form-control">
                                        <option value="">选择合作状态</option>
                                        <option value="1">合作</option>
                                        <option value="0">终止</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                        type="submit" alt="搜索" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-7 text-right">
                                <a id="createBtn" data-handle="createModel"
                                    class="btn btn-outline btn-primary">添加</a>
                                <div id="suppliersModal" class="modal inmodal" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                </div>
                            </div>
                        </form>
                    </div>
                    <table id="suppliersDataTable" width="100%"
                        class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/suppliers/suppliers.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createSuppliersForm" name="suppliersForm" action="${ctx}/api/role/create">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#suppliers.id}}编辑供应商{{/suppliers.id}}{{^suppliers.id}}添加供应商{{/suppliers.id}}</h6>
        </div>
        <div class="modal-body">
                <div class="form-group">
                    <label>供应商编码：</label>
                    <input id="suppliersid" name="id" value="{{suppliers.id}}" type="hidden">
                    <input id="suppliersCode" name="code" value="{{suppliers.code}}" type="text"
                        class="form-control" placeholder="供应商编码" required />
                </div>
                <div class="form-group">
                    <label>中文名称：</label>
                    <input id="name" name="name" value="{{suppliers.name}}" type="text"
                        class="form-control" placeholder="中文名称" required />
                </div>
                <div class="form-group">
                    <label>简称：</label>
                    <input id="shortName" name="shortName" value="{{suppliers.shortName}}" type="text"
                        class="form-control" placeholder="简称" required />
                </div>
				<div class="form-group">
                    <label>排序：</label>
                    <input id="displayOrder" name="displayOrder" value="{{suppliers.displayOrder}}" type="text"
                        class="form-control" placeholder="排序" required />
                </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitRole" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="role-edit" data-id="{{id}}"  class="btn btn-primary btn-xs" type="button">编 辑</button>
<button data-handle="role-operation" data-id="{{id}}" class="btn {{#useable}}btn-primary{{/useable}} {{^useable}}btn-danger{{/useable}} btn-xs" data-useable="{{useable}}" type="button">{{content}}</button>
{{/editBtn}}
</script>
</body>

