<%@ page contentType="text/html;charset=UTF-8" %>
<title>用户管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>管理用户列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                	<div class="min">
                        <div class="row">
                            <form id="searchForm">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <input id="searchKeyword" name="keyword" type="text"
                                            class="form-control valid" placeholder="用户名/姓名">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <select id="searchStatus" name="status" data-placeholder="选择状态" class="form-control">
                                            <option value="">全部状态</option>
                                            <option value="OPEN">启用</option>
                                            <option value="LOCK">锁定</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                            type="submit" alt="搜索" title="搜索">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-5 text-right">
                                    <a id="createBtn" data-handle="createModel"
                                        class="btn btn-outline btn-primary">添加</a>
                                    <div id="roleModal" class="modal inmodal" tabindex="-1"
                                        role="dialog" aria-hidden="true">
                                    </div>
                                </div>
                            </form>
                        </div>
                        <table id="roleDataTable" width="100%"
                            class="table table-striped table-bordered table-hover">
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/user/admin.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createRoleForm" name="roleForm" action="${ctx}/api/role/create">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#admin.username}}编辑管理用户{{/admin.username}}{{^admin.username}}添加管理用户{{/admin.username}}</h6>
        </div>
        <div class="modal-body">
                <div class="form-group">
                    <label>用户名：</label>
                    <input id="id" name="id" value="{{admin.id}}" type="hidden">
                    {{#admin.username}}
                        {{admin.username}}
                    {{/admin.username}}
                    {{^admin.username}}
                        <input id="username" name="username" value="{{admin.username}}" type="text"
                            placeholder="登录名" required class="form-control" />
                    {{/admin.username}}
                </div>
                <div class="form-group">
                    <label>姓名：</label>
                    <input id="name" name="name" value="{{admin.name}}" type="text"
                        class="form-control" placeholder="姓名" required />
                </div>
                <div class="form-group">
                    <label>密码：</label>
                    <input id="password" name="password" value="" type="password"
                        placeholder="密码"  class="form-control"  {{^admin.username}} required {{/admin.username}} />
                </div>
                <div class="form-group">
                    <label>确认密码：</label>
                    <input id="plainPassword" name="plainPassword" value="" type="password"
                        class="form-control" placeholder="确认密码" {{^admin.username}} required {{/admin.username}}/>
                </div>
                <hr/>
                <div class="ibox float-e-margins border-bottom">
                    <div class="ibox-title">
                        <h5>角色分配</h5>
                        <div class="ibox-tools">
                            <a class="collapse-link">
                                <i class="fa fa-chevron-up"></i>
                            </a>
                        </div>
                    </div>
                    <div class="ibox-content" style="display:none;">
                        <div class="row ">
                            {{#roles}}
                                <div class="col-md-4 col-xs-4 form-group role-item ellips">
                                <label for="role_{{id}}" ><input id="role_{{id}}" type="checkbox" {{#hasRoleChecked}}checked{{/hasRoleChecked}} class="i-checks" data-checkbox="sub"
                                    name="roles[{{rolesIndex}}].id" value="{{id}}">
                                    <span title="{{name}}">{{name}}</span></label>
                                </div>
                            {{/roles}}
                        </div>
                    </div>
                </div>
                <div class="ibox float-e-margins border-bottom ">
                    <div class="ibox-title">
                        <h5>供应商分配</h5>
                        <div class="ibox-tools">
                            <a class="collapse-link">
                                <i class="fa fa-chevron-up"></i>
                            </a>
                        </div>
                    </div>
                    <div class="ibox-content" style="display:none;">
                        <div class="row ">
                            {{#allSuppliers}}
                                <div class="col-md-4 col-xs-4 form-group role-item ellips">
                                <label for="suppliers_{{id}}">
								<input id="suppliers_{{id}}" type="checkbox" {{#hasrSuppChecked}}checked{{/hasrSuppChecked}} class="i-checks" data-checkbox="sub"
                                    name="suppliers[{{suppIndex}}].id" value="{{id}}">
                                    <span title="{{name}}">{{name}}</span></label>
                                </div>
                            {{/allSuppliers}}
                        </div>
                    </div>
                </div>

                <div class="ibox float-e-margins border-bottom">
                    <div class="ibox-title">
                        <h5>现有权限如下</h5>
                        <div class="ibox-tools">
                            <a class="collapse-link">
                                <i class="fa fa-chevron-up"></i>
                            </a>
                        </div>
                    </div>
                    <div class="ibox-content" style="display:none;">
                        <div class="row ">
                            {{#allPermissions}}
                                {{#value}}
                                    <div class="col-md-4 col-xs-4 form-group role-item ellips">
                                        <span title="{{label}}">{{label}}</span>
                                    </div>
                                {{/value}}
                            {{/allPermissions}}
                            {{^allPermissions}}
                                目前无任何权限
                            {{/allPermissions}}
                        </div>
                    </div>
                </div>

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitRole" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
   <button data-handle="role-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编 辑</button>
	{{#open}} 
     <button data-handle="role-operation" data-id="{{id}}" class="btn btn-primary btn-xs" data-status="OPEN" type="button">启用</button>
	{{/open}} 	
  
    {{#lock}} 
	<button data-handle="role-operation" data-id="{{id}}" class="btn  btn-danger btn-xs"  data-status="LOCK" type="button">锁定</button>
	{{/lock}} 
{{/editBtn}}
</script>
</body>

