<%@ page contentType="text/html;charset=UTF-8" %>
<title>会员管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <link href="${ctx}/static/css/upload.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/layer/laydate/laydate.js"></script>
    <link href="${ctx}/static/hplus/js/plugins/layer/skin/layer.css" rel="stylesheet">
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li><a href="/">主页</a></li>
            <li><strong>会员管理</strong></li>
        </ol>
    </div>
    <div class="col-lg-2"></div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input name="keyword" type="text"
                                           class="form-control valid" placeholder="用户名/姓名/手机号"/>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <input type="text" id="startDate" name="registStartDate"
                                           class="laydate-icon form-control layer-date" placeholder="注册日期起"/>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <input type="text" id="endDate" name="registEndDate"
                                           class="laydate-icon form-control layer-date" placeholder="注册日期止"/>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <select id="status" name="status" class="form-control">
                                        <option value="">选择状态</option>
                                        <option value="OPEN">开启</option>
                                        <option value="LOCK">锁定</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                            type="submit" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-7 text-right">
                            </div>
                        </form>
                    </div>
                    <table id="userlevelDataTable" width="100%"
                           class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<script src="${ctx}/static/js/user/user.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#editBtn}}
<button data-handle="admin-operation" data-id="{{id}}" class="btn {{#ok}}btn-danger{{/ok}}{{^ok}}btn-primary{{/ok}} btn-xs" data-status="{{status}}" type="button">{{#ok}}禁用{{/ok}}{{^ok}}启用{{/ok}}</button>
{{/editBtn}}


</script>
</body>