<%@ page contentType="text/html;charset=UTF-8" %>
<title>仓库字典管理</title>
<head>
    <link href="${ctx}/static/hplus/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="${ctx}/static/hplus/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <script src="${ctx}/static/hplus/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="${ctx}/static/hplus/js/plugins/dataTables/dataTables.bootstrap.js"></script>
</head>
<body>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <ol class="breadcrumb">
            <li>
                <a href="/">主页</a>
            </li>
            <li>
                <strong>仓库列表</strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">

            <div class="ibox">
                <div class="ibox-content">
                    <div class="row">
                        <form id="searchForm">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input id="searchKeyword" name="keyword" type="text"
                                           class="form-control valid" placeholder="编码/名称">
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <button id="searchBtn" class="btn btn-white btn-bitbucket"
                                            type="submit" alt="搜索" title="搜索">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-7 text-right">
                                <a id="createBtn" data-handle="createModel"
                                   class="btn btn-outline btn-primary">添加</a>

                                <div id="warehouseModal" class="modal inmodal" tabindex="-1"
                                     role="dialog" aria-hidden="true">
                                </div>
                            </div>
                        </form>
                    </div>
                    <table id="warehouseDataTable" width="100%"
                           class="table table-striped table-bordered table-hover">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="${ctx}/static/hplus/js/plugins/validate/jquery.validate.min.js"></script>
<script src="${ctx}/static/hplus/js/plugins/validate/messages_zh.min.js"></script>
<!-- iCheck -->
<script src="${ctx}/static/hplus/js/plugins/iCheck/icheck.min.js"></script>
<script src="${ctx}/static/js/warehouse/warehouse.js"></script>
<script id="hoganTmpl" type="text/mustache">
{{#modal}}
<div class="modal-dialog">
    <form id="createWarehouseForm" name="warehouseForm" action="${ctx}/api/warehouse/create">
    <div class="modal-content animated bounceInRight">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span><span class="sr-only">关闭</span>
            </button>
            <h6 class="modal-title">{{#warehouse.id}}编辑仓库字典{{/warehouse.id}}{{^warehouse.id}}添加仓库字典{{/warehouse.id}}</h6>
        </div>
        <div class="modal-body">
                <div class="form-group">
                    <label>仓库编码：</label>
                    <input id="expid" name="id" value="{{warehouse.id}}" type="hidden">
                    <input id="code" name="code" value="{{warehouse.code}}" type="text"
                            placeholder="编码" required class="form-control" />
                </div>
                <div class="form-group">
                    <label>仓库名称：</label>
                    <input id="warehouse_name" name="name" value="{{warehouse.name}}" type="text"
                        class="form-control" placeholder="名称" required />
                </div>
                <div class="form-group">
                    <label>联系人：</label>
                    <input id="warehouse_contact" name="contact" value="{{warehouse.contact}}" type="text"
                        placeholder="联系人" class="form-control" />
                </div>
                <div class="form-group">
                    <label>联系电话：</label>
                    <input id="warehouse_telephone" name="telephone" value="{{warehouse.telephone}}" type="text"
                        placeholder="联系电话" class="form-control" />
                </div>
                <div class="form-group">
                    <label>传真：</label>
                    <input id="warehouse_fax" name="fax" value="{{warehouse.fax}}" type="text"
                        placeholder="传真" class="form-control" />
                </div>
                <div class="form-group">
                    <label>地址：</label>
                    <input id="warehouse_address" name="address" value="{{warehouse.address}}" type="text"
                        placeholder="地址" class="form-control" />
                </div>
                <div class="form-group">
                    <label>邮政编码：</label>
                    <input id="warehouse_postcode" name="postcode" value="{{warehouse.postcode}}" type="text"
                        placeholder="邮政编码" class="form-control" />
                </div>
                <div class="form-group">
                    <label>备注：</label>
                    <input id="warehouse_note" name="note" value="{{warehouse.note}}" type="text"
                        placeholder="备注" class="form-control" />
                </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-white" data-dismiss="modal">关闭</button>
            <button id="submitWarehouse" type="submit" class="btn btn-primary">保存</button>
        </div>
    </div>
    </form>
</div>
{{/modal}}
{{#editBtn}}
<button data-handle="warehouse-edit" data-id="{{id}}" class="btn btn-primary btn-xs" type="button">编 辑</button>
<button data-handle="warehouse-operation" data-id="{{id}}" class="btn {{#isOpenBtn}}btn-primary{{/isOpenBtn}} {{^isOpenBtn}}btn-danger{{/isOpenBtn}} btn-xs" data-state="{{state}}" type="button">{{content}}</button>
{{/editBtn}}

</script>
</body>

