(function (window, document, $, Hogan, RocoUtils) {
    function Adv() {
        this.template = null;
        this.advDataTable = null;
        this.dataTable = null;
        this.searchForm = null;
        this.searchParam = null;
        this.createBtn = null;
        this.advModal = null;
        this.categories = null;
        this.types = [
            {id: 'INDEX_PAGE_BANNER', name: '首页轮播图'},
            {id: 'PRODUCT_PAGE_BANNER', name: '商品页轮播图'}
        ];
        this.init();
        this.initTypes();
        this.drawTable();
        this.bindEvent();
    }

    Adv.prototype.init = function () {
        this.template = Hogan.compile($('#hoganTmpl').html());
        this.advDataTable = $('#advDataTable');
        this.searchForm = $('#searchForm');
        this.createBtn = $('#createBtn');
        this.advModal = $('#advModal');
    }

    Adv.prototype.initTypes = function () {
        var self = this;
        $('#searchTypes').append(self.template.render({
            typeOptions: {
                types: self.types
            }
        }));
    }

    Adv.prototype.drawTable = function () {
        var self = this;
        self.dataTable = self.advDataTable.DataTable({
            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
                data: "id",
                visible: false
            }, {
                data: 'index',
                title: '',
                className: 'td_center',
                width: '3%'
            }, {
                data: 'type',
                title: '广告类型',
                width: '10%',
                render: function (data) {
                    switch (data) {
                        case 'INDEX_PAGE_BANNER':
                            return '首页轮播图';
                        case 'PRODUCT_PAGE_BANNER':
                            return '商品页轮播图';
                        default:
                            return '';
                    }
                }
            }, {
                data: 'title',
                title: '广告标题',
                width: '15%'
            }, {
                data: 'bgColor',
                title: '背景色',
                width: '6%',
                render: function (data) {
                    return '<span class="input-group-addon" style="background-color: ' + data + ';"><i></i></span>';
                }
            }, {
                data: 'slogan',
                title: '广告语',
                width: '15%'
            }, {
                data: 'sortId',
                title: '显示顺序',
                width: '10%'
            }, {
                data: 'createTime',
                title: '创建时间',
                width: '12%'
            }, {
                data: 'status',
                title: '状态',
                width: '10%',
                render: function (data) {
                    return 'OPEN' == data ? '上线' : '下线';
                }
            }, {
                data: 'id',
                title: '操作',
                width: '30%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return self.template.render({
                        editBtn: {
                            id: full.id,
                            content: function () {
                                return full.status == 'OPEN' ? '下线' : '上线';
                            },
                            status: full.status,
                            isOpenBtn: full.status == 'LOCK'
                        }
                    });
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/banners',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), self.searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange: false, // 是否允许显示分页数
            order: [0, 'desc'],
            initComplete: function () {
            }

        });
    };

    Adv.prototype.bindEvent = function () {
        var self = this;

        // 通用事件先写
        self.dataTable.on('order.dt search.dt', function () {
            self.dataTable.column(1, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        });

        self.searchForm.on('submit', function () {
            self.searchParam = RocoUtils.parseQueryString(self.searchForm.serialize());
            self.dataTable.ajax.reload(null, true);
            return false;
        });

        self.createBtn.on('click', function (event) {
            self.showModal();
            UploadTools.createTo('uploadImg', 'img', 'AD', 'imgUrl', 1);
            event.stopPropagation();
        });

        // 消失前销毁富文本编辑器
        self.advModal.on('hide.bs.modal', function () {
        });


        // 编辑按键点击
        self.dataTable.on('click', '[data-handle="adv-edit"]', function (event) {
            var id = $(this).data('id');
            $.ajax({
                url: ctx + '/api/banners/' + id + '/get',
                type: 'get',
                dataType: 'json',
                cache: false,
                success: function (res) {
                    if (res.code == 1) {
                        self.showModal(res.data);
                        if (res.data) {
                            var files = null;
                            var imgPath = res.data.imgUrl;
                            if (imgPath) {
                                if (files == null) {
                                    files = [];
                                }
                                var imgName = imgPath.substring(imgPath.lastIndexOf("/") + 1, imgPath.lastIndexOf("."));
                                files[files.length] = {
                                    "name": imgName,//图片名称
                                    fullPath: imgPath,
                                    path: imgPath,
                                    type: 'image'   //图片 image Excel  excel
                                };
                            }
                            UploadTools.createTo('uploadImg', 'img', 'ADV', 'imgUrl', 2, files);
                        }
                    }
                }
            });
            event.stopPropagation();
        });

        self.advDataTable.on('click', '[data-handle="adv-operation"]', function (event) {
            var id = $(this).data('id');
            var status = $(this).data('status');
            status = status == 'OPEN' ? 'LOCK' : 'OPEN';
            var hit = status == 'OPEN' ? '上线' : '下线';
            swal({
                title: "你确定将该广告" + hit + "吗?",
                text: "",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "确定",
                cancelButtonText: "取消",
                closeOnConfirm: false
            }, function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: ctx + '/api/banners/update',
                        type: 'post',
                        dataType: 'json',
                        data: {
                            id: id,
                            status: status
                        },
                        cache: false
                    }).done(function (res) {
                        if (res.code == 1) {
                            swal("操作成功!", "", "success");
                            // 刷新列表
                            self.dataTable.ajax.reload();
                        }
                    }).error(function () {
                        swal("操作失败！", "", "error");
                    });
                }
            });
            event.stopPropagation();
        });

        // 删除按钮
        self.advDataTable.on('click', '[data-handle="adv-del"]', function (event) {
            var id = $(this).data('id');
            swal({
                title: "你确定删除该广告吗?",
                text: "警告:删除后不可恢复！",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "确定",
                cancelButtonText: "取消",
                closeOnConfirm: false
            }, function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: ctx + '/api/banners/' + id + '/delete'
                    }).done(function (res) {
                        if (res.code == 1) {
                            swal("操作成功!", "", "success");
                            // 刷新列表
                            self.dataTable.ajax.reload();
                        }
                        if (res.code == 0) {
                            swal("删除失败!", res.message, "error");
                        }
                    }).error(function () {
                        swal("操作失败！", "", "error");
                    });
                }
            });
            event.stopPropagation();
        });
    }

    Adv.prototype.showModal = function (adv) {
        var self = this;
        if (!adv) {
            adv = {
                id: 0,
                bgColor: '#000000'
            };
        }
        self.advModal.html(self.template.render({
            modal: true,
            adv: adv,
            types: self.types,
            selected: function () {
                if (adv) {
                    return this.id === adv.type ? 'selected' : '';
                }
                return '';
            }
        }));
        // 激活colorpicker
        self.advModal.find('#bgColorComponent').colorpicker({
            horizontal: true,
            format: 'hex',
            color: adv.bgColor
        });
        // 激活上传
        self.advModal.find('#file').fileupload({
            dataType: 'json',
            multiple: false,
            formData: {
                // 指定上传类型
                'uploadCategory': 'ADV_IMG'
            },
            limitMultiFileUploadSize: 2048000000, // 单个文件最大上传容量，单位为byte
            limitMultiFileNumber: 1,
            acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i, // 允许上传文件类型
            done: function (e, data) {
                console.log(data);
                if (data.result.code == 1) {
                    var imgUrl = data.result.data.path;
                    self.advModal.find('#imgUrl').val(imgUrl);
                }
            }
        });
        self.advModal.modal({
            keyboard: true
        });
        var $form = self.advModal.find('form');
        // 表单验证
        $form.validate({
            rules: {
                title: {
                    required: true,
                    maxlength: 20
                },
                bgColor: {
                    required: true,
                    maxlength: 7
                },
                slogan: {
                    required: true,
                    maxlength: 60
                },
                imgUrl: {
                    required: true,
                    maxlength: 60
                },
                linkUrl: {
                    required: true,
                    maxlength: 60
                },
                sortId: {
                    required: true,
                    maxlength: 10,
                    number: true
                }
            },
            submitHandler: function (form) {
                $.ajax({
                    url: form.id.value != "0" ? (ctx + '/api/banners/update') : (ctx + '/api/banners/save'),
                    type: 'post',
                    dataType: 'json',
                    data: $(form).serialize(),
                    traditional: true,
                    cache: false,
                    beforeSend: function () {
                        self.btnDisable();
                    },
                    success: function (res) {
                        if (res.code == "1") {
                            toastr.success('操作成功');
                            self.advModal.modal('hide');
                            // 刷新列表
                            self.dataTable.ajax.reload();
                        }
                    },
                    complete: function () {
                        self.btnEnable();
                    }
                });
                return false;
            }
        });
    }
    Adv.prototype.btnDisable = function () {
        $('#deleteRankType').attr('disabled', 'disabled');
        $('#submitRankType').attr('disabled', 'disabled');
    };

    // 启用按钮
    Adv.prototype.btnEnable = function () {
        $('#deleteRankType').removeAttr('disabled');
        $('#submitRankType').removeAttr('disabled');
    };

    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'adv');
        new Adv();

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);