(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'brand');

        var template = Hogan.compile($('#hoganTmpl').html());
        var brandDataTable = $("#brandDataTable");

        // 初始化列表
        var dataTable = $('#brandDataTable').DataTable({

            // 预设一些列的属性
            columnDefs: [
                {
                    defaultContent: '',
                    targets: '_all'
                }, {
                    orderable: false,
                    targets: '_all'
                }, {
                    visible: false,
                    targets: [0, 1]
                }
            ],

            columns: [{
                data: 'display_order'
            }, {
                data: 'english_name'
            }, {
                width: '4%'
            }, {
                data: 'name',
                title: '中文名称',
                width: '15%'
            }, {
                data: 'englishName',
                orderData: [1],
                title: '英文名称',
                width: '15%'
            }, {
                data: 'imagePath',
                title: '缩略图',
                width: '20%',
                className: 'list-thumb',
                render: function (data, type, full, meta) {
                    var imgUrl = full.fullImageUrl;
                    if (imgUrl != '' && imgUrl != undefined && new RegExp("[jpg|jpeg|png|gif]$").test(imgUrl)) {
                        return "<img src='" + imgUrl + "'/>";
                    }
                    return '';
                }
            }, {
                data: 'displayOrder',
                title: '排序值',
                orderData: [0],
                width: '15%'
            }, {
                data: 'status',
                title: '状态',
                width: '15%',
                render: function (data, type, full, meta) {
                    return data == 'OPEN' ? '启用' : '禁用';
                }
            }, {
                data: 'id',
                title: '操作',
                width: '20%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: {
                            id: data,
                            content: function () {
                                return full.status == 'OPEN' ? '禁用' : '启用';
                            },
                            status: full.status,
                            isOpenClick: function () {
                                return !(full.status == 'OPEN');
                            }
                        }
                    });
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/brand',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            lengthChange: false,
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
        });

        // 首列显示序号,并且监听搜索排序事件,重新渲染序号
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(2, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 生成静态文件按钮
        var generateJsBtn = $('#brand_generate_js');
        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var brandModal = $('#brandModal');


        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="brand-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/brand/' + id,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(brandModal, res.data, null);
                            if (res.data) {
                                var files = null;
                                var imgPath = res.data.fullImageUrl;
                                if (imgPath) {
                                    if (files == null) {
                                        files = [];
                                    }
                                    var imgName = imgPath.substring(imgPath.lastIndexOf("/") + 1, imgPath.lastIndexOf("."));
                                    files[files.length] = {
                                        "name": imgName,//图片名称
                                        fullPath: imgPath,
                                        path: imgPath,
                                        type: 'image'   //图片 image Excel  excel
                                    };
                                }
                                UploadTools.createTo('uploadImg', 'img', 'BRAND', 'brand_imagePath', 2, files);
                            }
                        }
                    }
                });
                event.stopPropagation();
            });

            // 生成静态文件事件
            generateJsBtn.on('click', function (event) {
                $.ajax({
                    url: ctx + '/api/generatejs/list/brands',
                    type: 'get',
                    dataType: 'json',
                    data: {},
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('js文件生成成功');
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
            });

            // 锁定开启 按键点击
            dataTable.on('click', '[data-handle="brand-operation"]', function (event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                status = status == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/brand/update',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        status: status
                    },
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            //brandModal.modal('hide');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function (event) {
                // 绑定窗体事件
                bindModalEvent(brandModal, '', null);
                UploadTools.createTo('uploadImg', 'img', 'BRAND', 'brand_imagePath', 1);
                event.stopPropagation();
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                brand: data || {}
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');


            // 表单验证
            $form.validate({
                submitHandler: function (form) {
                    var extraStr = "&imagePath=" + form.imagePath.value;
                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/brand/update') : (ctx + '/api/brand/create'),
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize() + extraStr,
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });

            // 局部支持拖拽上传需添加此代码
            $(document).bind('drop dragover', function (e) {
                e.preventDefault();
            });


        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);