(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('cent', 'rule');

        var template = Hogan.compile($('#hoganTmpl').html());
        var searchParam = {};
        // 初始化列表
        var sendDataTable = $('#sendDataTable').DataTable({
            columns: [{
                data: 'index',
                title: '',
                defaultContent: '',
                className: 'td_center',
                orderable: false,
                width: '3%'
            }, {
                data: 'user.username',
                title: '用户名',
                width: '10%'
            }, {
                data: 'code',
                title: '积分编码',
                width: '10%'
            }, {
                data: 'cent',
                title: '积分值',
                width: '6%',
                className: 'td_cent'
            }, {
                data: 'balance',
                title: '余额',
                width: '6%',
                className: 'td_cent',
                render: function (data, type, full, meta) {
                    return "￥" + RocoUtils.formatNumber(data, true);
                }
            }, {
                data: 'effectiveDate',
                title: '生效日期',
                width: '10%'
            }, {
                data: 'expireDate',
                title: '失效日期',
                width: '10%'
            }, {
                data: 'status',
                title: '状态',
                width: '5%',
                className: 'td_center',
                render: function (data, type, full, meta) {
                    return emunStatus[data];
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/cents?ruleCode=' + $("#goCode").val(),
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [7, 'asc'],
            lengthChange: false, // 是否允许显示分页数
            initComplete: function () {
            }
        });

        // 首列显示序号,并且监听搜索排序事件,重新渲染序号
        sendDataTable.on('order.dt search.dt', function () {
            sendDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        var usedDataTable = $('#usedDataTable').DataTable({
            columns: [{
                data: 'index',
                title: '',
                defaultContent: '',
                className: 'td_center',
                orderable: false,
                width: '3%'
            }, {
                data: 'id',
                visible: false
            }, {
                data: 'snNum',
                title: '流水号',
                width: '15%',
                orderable: false
            }, {
                data: 'consumeType',
                title: '消耗类型',
                width: '20%',
                render: function (data, type, full, meta) {
                    return data.name;
                },
                orderable: false
            }, {
                data: 'user',
                title: '会员名',
                width: '15%',
                render: function (data, type, full, meta) {
                    return data.username;
                },
                orderable: false
            }, {
                data: 'consumeCent',
                title: '所耗积分',
                width: '15%',
                className: 'td_cent',
                render: function (data, type, full, meta) {
                    return RocoUtils.formatNumber(data, false);
                },
                orderable: true
            }, {
                data: 'dateline',
                title: '时间',
                width: '15%',
                orderable: true
            }
            ],

            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/consume/rulecode/' + $("#goCode").val(),
                type: 'GET'
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#usedDataTable_length').hide();
            }
        });

        usedDataTable.on('order.dt search.dt', function () {
            usedDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();


        // 添加按钮
        var backBtn = $('#backBtn');
        //发送
        var sendBtn = $("#sendBtn");
        //使用
        var usedBtn = $("#usedBtn");

        var today = $("#today");
        var thisMonth = $("#thisMonth");
        var customTime = $("#customTime");

        // 绑定事件
        var bindEvent = function () {

            backBtn.on("click", function () {
                $("#backForm").submit();
            })

            sendBtn.on('click', function () {
                $(this).attr("class", "btn btn-primary btn-xs active")
                usedBtn.attr("class", "btn btn-white btn-xs active");
                thisMonth.attr("class", "btn btn-white btn-xs active");
                customTime.attr("class", "btn btn-white btn-xs active");
                today.attr("class", "btn btn-white btn-xs active");
                searchParam = {};
                $("#sendDiv").show();
                $("#usedDiv").hide();
                sendDataTable.ajax.reload();

            });

            usedBtn.on("click", function () {
                $(this).attr("class", "btn btn-primary btn-xs active")
                sendBtn.attr("class", "btn btn-white btn-xs active");
                $("#sendDiv").hide();
                $("#usedDiv").show();
                usedDataTable.ajax.reload();
            })

            today.on("click", function () {
                thisMonth.attr("class", "btn btn-white btn-xs active");
                customTime.attr("class", "btn btn-white btn-xs active");
                today.attr("class", "btn btn-primary btn-xs active");
                searchParam = {time: 'today'};
                sendDataTable.ajax.reload();

            })

            thisMonth.on("click", function () {
                thisMonth.attr("class", "btn btn-primary btn-xs active");
                customTime.attr("class", "btn btn-white btn-xs active");
                today.attr("class", "btn btn-white btn-xs active");
                searchParam = {time: 'month'};
                sendDataTable.ajax.reload();
            })

            customTime.on("click", function () {
                thisMonth.attr("class", "btn btn-white btn-xs active");
                customTime.attr("class", "btn btn-primary btn-xs active");
                today.attr("class", "btn btn-white btn-xs active");
                customTime.layDateTwoChoose({
                    one: '#customTime', callback: function (dateOne, dateTwo) {
                        searchParam = {startDate: dateOne, endDate: dateTwo};
                        sendDataTable.ajax.reload();
                        console.log(dateOne + "至" + dateTwo);
                    }
                });
            })
        };

        bindEvent();

        var emunStatus = {
            'CANUSE': '可用',
            'USED': '已使用',
            'INVALID': '已失效',
            'LOCK': '锁定'
        };

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);