(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('cent', 'rule');

        var template = Hogan.compile($('#hoganTmpl').html());
        var centRuleDataTable = $("#centRuleDataTable");

        // 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间 参数为JQuery选择器的值 如 '#startDate'
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,    //需显示日期的元素选择器
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };

            laydate(startDate);
            laydate(endDate);
        }

        // 加载查询条件中的时间空间
        initDateControl('#startDateSearch', '#endDateSearch');

        // 所有归属类型
        var centConsumes = null;
        // 当前归属类型
        var centConsume = null;

        // 初始化搜索的下拉选
        var initSelect = function () {
            $.ajax({
                url: ctx + '/api/centconsume/owner',
                type: "GET",
                dataType: "json",
                asyn: false,
                success: function (res, status) {
                    centConsumes = res.data;
                }
            });
        };

        initSelect();

        // 初始化列表
        var dataTable = $('#centRuleDataTable').DataTable({

            // 预设一些列的属性
            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0, 1, 2, 3]
            }, {
                orderable: false,
                targets: [0, 1, 2, 3, 4]
            }],

            columns: [{
                data: 'id'
            }, {
                data: 'total_cent'
            }, {
                data: 'start_date'
            }, {
                data: 'end_date'
            }, {
                className: 'td_center',
                width: '3%'
            }, {
                data: 'code',
                title: '编码',
                width: '8%',
                render: function (data, type, full, meta) {
                	return "<a href='javaScript:void(0)' data-handle='go' data-id='"+full.id+"'>"+data+"</a>"
                }
            }, {
                data: 'name',
                title: '名称',
                width: '10%'
            }, {
                data: 'budget',
                title: '预算额度',
                className: 'td_cent',
                width: '10%',
                render: function (data, type, full, meta) {
                    return RocoUtils.formatNumber(data, false);
                }
            }, {
                data: 'cent',
                title: '单次分值',
                className: 'td_cent',
                width: '10%',
                render: function (data, type, full, meta) {
                    return RocoUtils.formatNumber(data, false);
                }
            }, {
                data: 'totalCent',
                title: '已使用',
                className: 'td_cent',
                width: '10%',
                orderData: [1],
                render: function (data, type, full, meta) {
                    return RocoUtils.formatNumber(data, false);
                }
            }, {
                data: 'startDate',
                title: '开始时间',
                width: '12%',
                orderData: [2],
                render: function (data, type, full, meta) {
                    return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd');
                }
            }, {
                data: 'endDate',
                title: '结束时间',
                width: '12%',
                orderData: [3],
                render: function (data, type, full, meta) {
                    return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd');
                }
            }, {
                data: 'status',
                title: '状态',
                width: '10%',
                render: function (data, type, full, meta) {
                    if (data == 'DRAFT')
                        return '草稿';
                    if (data == 'WAIT_AUDIT')
                        return '待审批';
                    if (data == 'OPEN')
                        return '开启';
                    if (data == 'LOCK')
                        return '停用';
                    if (data == 'ARTIFICIAL_CANCEL')
                        return '手工作废';
                    if (data == 'AUTO_CANCEL')
                        return '自动作废';
                }
            }, {
                data: 'id',
                title: '操作',
                width: '20%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        DRAFT : full.status == 'DRAFT' ? {id : data} : '',
                        WAITAUDIT : full.status == 'WAIT_AUDIT' ? {id : data} : '',
                        OPEN : full.status == 'OPEN' ? {id : data} : '',
                        LOCK : full.status == 'LOCK' ? {id : data} : '',
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/centrule',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange: false,
            order: [0, 'desc'],
        });

        // 首列显示序号,并且监听搜索排序事件,重新渲染序号
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(4, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var centRuleModal = $('#centRuleModal');


        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="centrule-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/centrule/' + id,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            $(centConsumes).each(function () {
                                if (this.id == res.data.consume.id)
                                    centConsume = this;
                            });
                            bindModalEvent(centRuleModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });
            
            dataTable.on('click', '[data-handle="go"]', function (event) {
            	var id = $(this).data('id');
            	searchForm.attr("action",ctx + '/api/centrule/detail/' + id);
            	searchForm.off('submit');
            	searchForm.submit();
            })
            
            
            // 绑定删除
            dataTable.on('click', '[data-handle="centrule-del"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/centrule/delete/' + id,
                    type: 'get',
                    dataType: 'json',
                    data: {},
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('删除成功');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            //提交审批
            dataTable.on('click', '[data-handle="centrule-submit"]', function (event) {
                changeState(this,"WAIT_AUDIT");
            });

            //审批通过
            dataTable.on('click', '[data-handle="centrule-pass"]', function (event) {
                changeState(this,"OPEN");
            });

            //审批不通过
            dataTable.on('click', '[data-handle="centrule-nopass"]', function (event) {
                changeState(this,"DRAFT");
            });

            //停用
            dataTable.on('click', '[data-handle="centrule-stop"]', function (event) {
                changeState(this,"LOCK");
            });

            //启用
            dataTable.on('click', '[data-handle="centrule-start"]', function (event) {
                changeState(this,"OPEN");
            });

            //作废
            dataTable.on('click', '[data-handle="centrule-cancel"]', function (event) {
                changeState(this,"ARTIFICIAL_CANCEL");
            });
            

            // 启用禁用 按键点击
            centRuleDataTable.on('click', '[data-handle="centrule-operation"]', function (event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                status = status == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/centrule/' + id + '/switch',
                    type: 'get',
                    dataType: 'json',
                    data: {
                        status: status
                    },
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function (event) {

                centConsume = null;
                bindModalEvent(centRuleModal, '', null);
                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {


            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                rule: data || {}
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            $modal.one('shown.bs.modal', function () {
                setTimeout(function () {
                    initDateControl('#centrule_startDate', '#centrule_endDate');
                    initDateControl('#centrule_effectiveDate');
                }, 1);
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            // 激活的checkbox滑块,在回调函数中处理checkbox的值
            $('.js-switch').bothSwitch({
                callback: function (status, listStatus) {
                    if (status)
                        $("#centrule_smsFlag").val("true");
                    else
                        $("#centrule_smsFlag").val("false");
                }
            });

            // 构建积分归属的下拉选
            $(centConsumes).each(function () {
                if (this.status == 'OPEN') {
                    if (centConsume != null && centConsume.id == this.id)
                        $("#centrule_consume").append("<option value='" + this.id + "' selected >" + this.name + "</option>");
                    else
                        $("#centrule_consume").append("<option value='" + this.id + "'>" + this.name + "</option>");
                }
            });

            // 处理有效期类型,根据不同的选择,显示不同的附加输入选项
            var effTypeChangeEvent = function () {
                var selectVal = $("#centrule_effectiveType").val();
                if (data != null && data != undefined && data != '') {
                    selectVal = data.effectiveType;
                }
                showExtendContent(selectVal);
            }

            var showExtendContent = function (selectVal) {
                if (selectVal == '0') {
                    $("option[value='0']").attr("selected", "");
                    $(".showEffectTime").show();
                    $(".showExtendDay").hide();
                }
                if (selectVal == '1') {
                    $("option[value='1']").attr("selected", "");
                    $(".showEffectTime").hide();
                    $(".showExtendDay").show();
                }
            }

            // 主要针对编辑页面的时候 进行下拉选的选择处理
            effTypeChangeEvent();

            // 绑定有效期类型的change事件,根据不同的选择,显示不同的附加输入选项
            $modal.on('change', '[data-handle="effectiveType-handle"]', function (event) {
                var selectVal = $("#centrule_effectiveType").val();
                showExtendContent(selectVal);
            });

            // 生成秘钥的事件
            $modal.on('click', '[data-handle="generate-key"]', function (event) {
                $.ajax({
                    url: ctx + '/api/centrule/securitykey',
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == "1") {
                            $("#centrule_secretKey").val(res.data);
                        }
                    }
                });
            });

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                    name: {
                        required: true,
                        maxlength: 20
                    },
                    description: {
                        required: true,
                        maxlength: 100
                    },
                    secretKey: {
                        required: true,
                        maxlength: 50
                    },
                    cent: {
                        required: true,
                        digits: true
                    },
                    budget: {
                        required: true,
                        digits: true
                    },
                    startDate: {
                        required: true
                    },
                    endDate: {
                        required: true
                    }
                },

                submitHandler: function (form) {

                    if ($("#centrule_secretKey").val() == '' || $("#centrule_secretKey").val() == null) {
                        toastr.warning("积分秘钥不能为空");
                        return false;
                    }

                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/centrule/update') : (ctx + '/api/centrule/create'),
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize() + "&secretKey=" + $("#centrule_secretKey").val(),
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
        
        // 修改状态
        var changeState = function(_this,state){
        	var id = $(_this).data('id');
        	$.ajax({
                url: ctx + '/api/centrule/'+ id + '/'+state,
                type: 'get',
                traditional: true,
                cache: false,
                success: function (res) {
                    if (res.code == "1") {
                        toastr.success('操作成功');
                        // 刷新列表
                        dataTable.ajax.reload();
                    }
                }
            });
        }
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);