(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('data-dict', 'centAttribution');

        var template = Hogan.compile($('#hoganTmpl').html());
        var expressDataTable = $("#expressDataTable");

        // 初始化列表
        var dataTable = $('#expressDataTable').DataTable({
            columns: [{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '5%'
            	},{
                    data: 'code',
                    title: '编码',
                    className:'td_left',
                    width: '35%'
                }, {
                    data: 'name',
                    title: '名称',
                    width: '45%',
                    className:'td_left',
                    orderable: true
                }, {
                    data: 'id',
                    title: '操作',
                    width: '15%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            editBtn: {
                                id: data,
                                status:full.status,
                                ok:full.status=="OPEN"?true:false
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/centconsume/owner',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#expressDataTable_length').hide();
            }
        });

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var centUseTypeModal = $('#centUseTypeModal');


        // 绑定事件
        var bindEvent = function() {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/centconsume/owner/' + id + '/getInfo',
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(centUseTypeModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 锁定开启 按键点击
            expressDataTable.on('click', '[data-handle="role-operation"]', function(event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                status = status == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/centconsume/owner/update',
                    type: 'post',
                    dataType: 'json',
                    data: {
                    	id : id,
                        status: status
                    },
                    cache: false,
                    beforeSend: function() {
                        //btnDisable();
                    },
                    success: function(res) {
                        if (res.code == 1) {
                            toastr.success("状态修改成功");
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function() {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function(event) {
                bindModalEvent(centUseTypeModal, null, null);
                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data : data || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');
            
            
            if($("#expid").val()){
            	$("#code").attr("disabled","disabled")
            }

            // 表单验证
            $form.validate({
                rules: {
                	code: {
                		required: true,
                		maxlength: 20
                	},
                	name: {
                		required: true,
                		maxlength: 50
                	}
                },
                submitHandler: function(form) {
                	
                	var formObj = {};
                    
                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/centconsume/owner/update') : (ctx + '/api/centconsume/owner/create'),
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();
        // 禁用按钮
        var btnDisable = function() {
            $('#submitExpress').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#submitExpress').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);