(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('cent', 'cents');
        var template = Hogan.compile($('#hoganTmpl').html());
        // 从服务端获得所有积分预算信息
        var ruleCodes = null;

        // 获取所有积分规则编码
        $.ajax({
            url: ctx + '/api/centrule/getAll',
            type: 'GET',
            dataType: 'json',
            data: {status: 'OPEN'},
            cache: false,
            success: function (res) {
                if (res.code == 1) {
                    ruleCodes = res.data;
                }
            }
        });
        // 加载搜索时间控件
        var initDateControl = function (elem) {
            var d = new Date();
            var m = d.getMonth() + 1;
            var day = d.getDate() < 10 ? "0" + d.getDate() : d.getDate();
            var dStr = d.getFullYear() + "-" + (m < 10 ? "0" + m : m) + "-" + day;
            var data = {
                elem: elem,
                format: 'YYYY-MM-DD',
                min: dStr,
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true
            };
            laydate(data);
        };

        // 展示批量发放的详情列表
        var batctDataTable = $('#batchIssueDataTable').DataTable({
            // 全局列属性定义
            columnDefs: [{
                defaultContent: '',
                orderable: false,
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }],

            columns: [{
                data: "id",
            }, {
                data: 'index',
                className: 'td_center',
                width: '3%'
            }, {
                data: 'ruleCode',
                title: '规则编码',
                width: '10%'
            }, {
                data: 'user.name',
                title: '操作人',
                width: '10%'
            }, {
                data: 'operateTime',
                title: '操作时间',
                width: '10%'
            }, {
                data: 'totalCent',
                title: '总分值',
                width: '10%',
                className: 'td_cent',
                render: function (data, type, full, meta) {
                    return RocoUtils.formatNumber(data, false);
                }
            }, {
                data: 'totalRecord',
                title: '总条数',
                width: '10%'
            }, {
                data: 'id',
                title: '明细',
                width: '10%',
                className: 'td_center',
                render: function (data, type, full, meta) {
                    return template.render({
                        showDetail: {
                            id: full.id,
                            show: true
                        }
                    });
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/centapply',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'asc'],
            lengthChange: false, // 是否允许显示分页数

        });
        // 显示序号
        batctDataTable.on('order.dt search.dt', function () {
            batctDataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();


        // 展示批量发放的详情列表
        var manualDataTable = $('#manualDataTable').DataTable({
            // 全局列属性定义
            columnDefs: [{
                defaultContent: '',
                orderable: false,
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }],

            columns: [{
                data: "id",
            }, {
                data: 'index',
                className: 'td_center',
                width: '3%'
            }, {
                data: 'ruleCode',
                title: '规则编码',
                width: '10%'
            }, {
                data: 'cents.cent',
                title: '积分',
                width: '10%',
                className:'td_cent',
                render: function (data) {
                    return RocoUtils.formatNumber(data, false);
                }
            }, {
                data: 'cents.user.username',
                title: '会员名',
                width: '10%'
            }, {
                data: 'user.name',
                title: '操作人',
                width: '10%'

            }, {
                data: 'operateTime',
                title: '操作时间',
                width: '10%'
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/centapply/addlist',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'asc'],
            lengthChange: false, // 是否允许显示分页数

        });
        // 显示序号
        manualDataTable.on('order.dt search.dt', function () {
            manualDataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();


        // search实现部分
        var searchForm = $('#searchForm'),
            searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 批量发放选项卡
        var batchIssue = $('#batchIssue');
        // 批量发放按钮
        var batchIssueBtn = $('#batchIssueBtn');
        // 批量发放明细的模式窗体
        var batchIssueModal = $('#batchIssueModal');
        // 手工发放选项卡
        var manualIssue = $('#manualIssue');
        // 手工发放按钮
        var manualIssueBtn = $('#manualIssueBtn');
        // 手工发放按钮的模式窗体
        var manualIssueModal = $('#manualIssueModal');
        // 绑定事件
        var bindEvent = function () {
            // 批量发放选项卡点击后的事件
            batchIssue.on('click', function (event) {
                $(this).attr('class', 'btn btn-primary btn-xs active');
                $(manualIssue).attr('class', 'btn btn-white btn-xs active');
                $('.batchIssueModal').show();
                $('.manualIssueModal').hide();
                $('#batchIssueTable').show();
                batctDataTable.ajax.reload();
                $('#manualIssueTable').hide();
            });
            // 手工发放选项卡点击后的事件
            manualIssue.on('click', function (event) {
                $(this).attr('class', 'btn btn-primary btn-xs active');
                $(batchIssue).attr('class', 'btn btn-white btn-xs active');
                $('.manualIssueModal').show();
                $('.batchIssueModal').hide();
                $('#manualIssueTable').show();
                $('#batchIssueTable').hide();
            });
            // 批量发放button点击事件
            batchIssueBtn.on('click', function (event) {
                showBatchIssueModal(batchIssueModal);
            });
            // 手工发放button点击事件
            manualIssueBtn.on('click', function (event) {
                showManualIssueModal(manualIssueModal);
            });
            // 绑定批量发放的明细事件
            batctDataTable.on('click', '[data-handle="show-detail"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/centapply/apply/' + id,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            showDetailModalEvent(batchIssueModal, res.data, id);
                        }
                    }
                });
            });
        };

        // 点击批量发放按钮事件展示的模式窗体
        var showBatchIssueModal = function ($modal) {
            $modal.html(template.render({
                importModel: true,
                ruleCodes: ruleCodes
            }));
            // 展示modal
            $modal.modal({
                keyboard: true
            });
            // 绑定下载模版事件
            $modal.on('click', '[data-handle="download-template"]', function () {
                window.location.href = ctx + '/api/centapply/download';
            });
            UploadTools.createTo('uploadExcel', 'xls', 'CENT_APPLY_IMPORT', 'filePath', 1);

            var $form = $modal.find('form');

            $form.validate({
                submitHandler: function (form) {

                    $.ajax({
                        url: ctx + '/api/centapply/batchImport',
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                setTimeout(function () {
                                    batctDataTable.ajax.reload();
                                }, 2);
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        // 点击手工发放按钮的事件展示的模式窗体
        var showManualIssueModal = function ($modal) {
            $modal.html(template.render({
                manualIssue: true,
                ruleCodes: ruleCodes
            }));
            // 加载时间控件
            $modal.one('shown.bs.modal', function () {
                setTimeout(function () {
                    initDateControl("#expireDate");
                }, 1);
            });
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            $modal.on('blur', '[data-handle="check-username"]', function (event) {
                var username = $(this).val();
                $.ajax({
                    url: ctx + '/api/user/username/' + username,
                    type: 'get',
                    dataType: 'json',
                    data: {},
                    success: function (res) {
                        if (res.code == "0") {
                            btnDisable();
                            return false;
                        } else {
                            btnEnable();
                            return true;
                        }
                    }
                });
            });

            var $form = $modal.find('form');
            // 表单验证
            $form.validate({
                rules: {
                    ruleCode: {
                        required: true
                    }, username: {
                        required: true
                    },
                    cent: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                        digits: true
                    }
                },
                submitHandler: function (form) {

                    $.ajax({
                        url: ctx + '/api/centapply/create',
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                manualDataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        // 展示批量发放明细的模式窗口
        var showDetailModalEvent = function ($modal, data, applyId) {
            $modal.html(template.render({
                applyDetail: true,
                apply: data || {}
            }));
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            // 加载分值详情的table
            var applyDetailTable = $('#applyDetailTable').DataTable({

                // 全局列属性定义
                columnDefs: [{
                    defaultContent: '',
                    orderable: false,
                    targets: '_all'
                }, {
                    visible: false,
                    targets: [0]
                }],

                columns: [{
                    data: "id",
                }, {
                    data: 'index',
                    className: 'td_center',
                    width: '3%'
                }, {
                    data: 'user.username',
                    title: '会员名',
                    width: '20%'
                }, {
                    data: 'code',
                    title: '积分编码',
                    width: '20%'
                }, {
                    data: 'cent',
                    title: '积分值',
                    width: '20%'
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/centapply/cents/' + applyId,
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), searchParam);
                    }
                },
                paging: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'asc'],
                lengthChange: false// 是否允许显示分页数
            });
            // 显示序号
            applyDetailTable.on('order.dt search.dt', function () {
                applyDetailTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
            }).draw();
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#submitCent').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#submitCent').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);