(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('cent', 'record');

        // 展示批量发放的详情列表
        var dataTable = $('#dataTable').DataTable({
            // 全局列属性定义
            columnDefs: [{
                defaultContent: '',
                orderable: false,
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                width: '10%',
                targets: [2, 3, 4, 5, 6, 7, 8, 9]
            }],

            columns: [{
                data: "id"
            }, {
                className: 'td_center',
                width: '3%'
            }, {
                data: 'ruleCode',
                title: '规则编码',
                width: '10%'
            }, {
                data: 'code',
                title: '积分编码'
            },{
                data: 'user.username',
                title: '会员名'
            }, {
                data: 'cent',
                title: '积分值',
                className: 'td_cent'
            }, {
                data: 'balance',
                title: '余额',
                className: 'td_cent'
            }, {
                data: 'effectiveDate',
                title: '生效日期',
	            render:function(data){
	        		return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd');
	        	}
            }, {
                data: 'expireDate',
                title: '有效截止日',
                render:function(data){
            		return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd');
            	}
            }, {
                data: 'status',
                title: '状态',
                render: function (data) {
                    if (data == 'CANUSE')
                        return '可用';
                    if (data == 'USED')
                        return '已使用';
                    if (data == 'INVALID')
                        return '已失效';
                    if (data == 'LOCK')
                        return '锁定';
                    if (data == 'FROZEN')
                        return '冻结';
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/cents',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'asc'],
            lengthChange: false, // 是否允许显示分页数

        });
        // 显示序号
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();


        // search实现部分
        var searchForm = $('#searchForm'),
            searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);