(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('cent', 'centuse');

        var template = Hogan.compile($('#hoganTmpl').html());
        var centUserDataTable = $("#centUserDataTable");

        // 获取所有积分消耗类型
        var centConsumeTypes = null;

        $.ajax({
            url: ctx + '/api/centconsume',
            type: 'get',
            dataType: 'json',
            success: function (res) {
                centConsumeTypes = res.data;
                $(centConsumeTypes).each(function () {
                    $("#consumeType").append("<option value='" + this.code + "'>" + this.name + "</option>");
                });
            }
        });

        // 初始化列表
        var dataTable = $('#centUserDataTable').DataTable({
            // 列属性定义
            columnDefs: [{
                defaultContent: '',
                orderable: false,
                targets: '_all'
            }],
            columns: [{
                data: 'dateline',
                visible: false
            }, {
                data: 'index',
                title: '',
                className: 'td_center',
                width: '3%'
            }, {
                data: 'snNum',
                title: '流水号',
                width: '15%'
            }, {
                data: 'consumeType',
                title: '消耗类型',
                width: '10%',
                render: function (data, type, full, meta) {
                    return data.name;
                }
            }, {
                data: 'user',
                title: '会员名',
                width: '15%',
                render: function (data, type, full, meta) {
                    return data.username;
                }
            }, {
                data: 'consumeCent',
                title: '所耗积分',
                width: '10%',
                className: 'td_cent',
                render: function (data, type, full, meta) {
                    return RocoUtils.formatNumber(data, false);
                },
            }, {
                data: 'dateline',
                title: '时间',
                width: '10%'
            }, {
                data: 'id',
                title: '操作',
                width: '10%',
                orderable: false,
                className: 'td_center',
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: {
                            id: data,
                            snNum: full.snNum
                        }
                    });
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/consume',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            lengthChange: false
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var centuseModal = $('#centuseModal');

        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function (event) {
                var id = $(this).data('id');
                var snnum = $(this).data('snnum');
                bindModalEvent(centuseModal, id, snnum);
                event.stopPropagation();
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, id, snnum) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                serialNum: snnum || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            $('#detailedDataTable').DataTable({
                columns: [{
                    data: 'id',
                    visible: false
                }, {
                    data: 'cent',
                    title: '积分编码',
                    width: '50%',
                    render: function (data, type, full, meta) {
                        return data.code;
                    },
                    orderable: false
                }, {
                    data: 'centAmt',
                    title: '消耗积分',
                    width: '40%',
                    orderable: false
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/consume/' + id + '/consumeDetail',
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), searchParam);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                initComplete: function () {
                    // 不显示每页多少条
                    $('#detailedDataTable_length').hide();
                    $('#detailedDataTable_paginate').hide();
                    $('#detailedDataTable_info').hide();
                }
            });
        };

        bindEvent();


        //初始化时间控件
        var init = function () {
            laydate({
                elem: '#startDate',
                event: 'focus'
            });
            laydate({
                elem: '#endDate',
                event: 'focus'
            });
            $.ajax({
                url: ctx + '/api/centconsume',
                type: 'post',
                dataType: 'json',
                data: {},
                success: function (data) {
                    var target = $("#consumeType");
                    var datas = data.data;
                    if (datas && datas.length > 0) {
                        $(datas).each(function () {
                            target.append("<option value='" + $(this).attr('code') + "'>" + $(this).attr('name') + "</option>")
                        })
                    }
                }
            });
            $.ajax({
                url: ctx + '/api/platform/all',
                type: 'get',
                dataType: 'json',
                data: {},
                success: function (data) {
                    var target = $("#platformCode");
                    var datas = data.data;
                    if (datas && datas.length > 0) {
                        $(datas).each(function () {
                            target.append("<option value='" + $(this).attr('code') + "'>" + $(this).attr('name') + "</option>")
                        })
                    }
                }
            });
        }
        init();

        // 禁用按钮
        var btnDisable = function () {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);