(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'classify');
        var template = Hogan.compile($('#hoganTmpl').html());
        var classModal = $('#classModal');

        // 绑定事件
        var bindEvent = function() {
        	var jstreeid2 = $("#jstreeid2");
        	//添加分类
        	$("#createBtn").on('click', function(e) {
        		bindModalEvent(classModal,null,null);
            });
        	
        	//添加子节点
        	$("#createClildBtn").on('click', function(e) {
                var node = jstreeid2.jstree("get_selected");
                if(node == ''){
                	toastr.error("请选择节点");
                	return;
                }
                var leave = jstreeid2.jstree("get_node", node);
                if($(leave.a_attr).attr("data-lev") == 3){
                	toastr.error("节点层级不能超过3层");
                }else{
                	bindModalEvent(classModal,null,node);
                }
            });
        	
        	//编辑
        	$("#editBtn").on('click', function(e) {
        		var node = jstreeid2.jstree("get_selected");
        		if(node == ''){
                	toastr.error("请选择节点");
                }else{
                	$.ajax({
                        url:ctx + "/api/catalog/"+node+"/getInfo",
                        success:function(res) {
                            if(res.code == "1") {
                            	bindModalEvent(classModal,res.data,null);
                            }
                        }
                    });
                }
            });
        	
        	//生成静态文件
        	$("#productBtn").on('click', function(e) {
            	$.ajax({
                    url:ctx + "/api/generatejs/catalogs",
                    success:function(res) {
                        if(res.code == "1") {
                        	toastr.success(res.message);
                        }
                    }
                });
            });
        };
        
        var init = function(){
        	//加载树
        	$.ajax({
                url:ctx + "/api/catalog/tree",
                success:function(res) {
                    if(res.code == "1") {
                        $("#jstreeid2").jstree({
                            'core': {
                                'data': res.data
                            },
                            "types": {
                                "default": {
                                    "icon": "glyphicon glyphicon-stop"
                                }
                            },
                            "plugins": ["types"]
                        });

                    }
                }
            });
        }

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, parentId) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data : data || {},
                parentId : parentId || '0'
            }));
            
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            if(data != null){
            	$("#status").find("option").each(function(){
                	if($(this).attr("value") == data.status){
                		$(this).attr("selected","true");
                	}
                })
            }
            

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                	classilfPid : {
                		required: false,
                		maxlength: 20
                	},
                	code: {
                		required: true,
                		maxlength: 20
                	},
                	name: {
                		required: true,
                		maxlength: 50
                	},
                	displayOrder : {
                		required: true,
                		maxlength: 10
                	}
                },
                submitHandler: function(form) {
                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/catalog/update') : (ctx + '/api/catalog/create'),
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                init();
                                $modal.modal('hide');
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        init();
        bindEvent();

        // 禁用按钮
        var btnDisable = function() {
            $('#submitExpress').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#submitExpress').removeAttr('disabled');
        };
        
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);