(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'coupons');

        var template = Hogan.compile($('#hoganTmpl').html());
        var couponsDataTable = $("#couponsDataTable");

        // 初始化列表
        var dataTable = $('#couponsDataTable').DataTable({
            columns: [{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '3%'
				},{
                    data: 'code',
                    title: '优惠券编码',
                    width: '15%',
                    render: function(data, type, full, meta) {
                    	return "<a href='javascript:void(0);' data-handle='info' data-id='"+full.id+"'>"+data+"</a>";
                    }
                }, {
                    data: 'name',
                    title: '优惠券规则',
                    width: '15%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	return "满"+full.fullAmt+"元，减"+full.minusAmt+"元";
                    }
                }, {
                    data: 'effectiveTime',
                    title: '生效时间',
                    width: '15%',
                    orderable: false
                }, {
                    data: 'unEffectiveTime',
                    title: '失效时间',
                    width: '15%',
                    orderable: false
                }, {
                    data: 'status',
                    title: '启用状态',
                    width: '15%',
                    orderable: true,
                    render: function(data, type, full, meta) {
                    	return data == "USING"? "启用" : "停用";
                    }
                }, {
                    data: 'effectiveStatus',
                    title: '有效状态',
                    width: '15%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	if(data ==1){
                    		return "<div style='text-align: center;color:#ffffff;background-color: #4ba84b'>有效</div>"
                    	}else if(data ==0){
                    		return "<div style='text-align: center;color:#ffffff;background-color: #5F9EA0'>未生效</div>"
                    	}else {
                    		return "<div style='text-align: center;color:#ffffff;background-color: #999999'>失效</div>"
                    	}
                    }
                }, {
                    data: 'id',
                    title: '操作',
                    width: '10%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	if(full.effectiveStatus ==-1){
                    		return "";
                    	}else{
                    		return template.render({
                                editBtn: {
                                    id: data,
                                    content: function() {
                                        return full.status == "DISABLE" ? '启用' : '停用';
                                    },
                                    status: function() {
                                        return full.status == "DISABLE" ? 'btn-primary' : 'btn-danger';
                                    }
                                }
                            })
                    	}
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/coupons',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#couponsDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var couponsModal = $('#couponsModal');


        // 绑定事件
        var bindEvent = function() {
            // 状态点击
            dataTable.on('click', '[data-handle="status"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/coupons/updateStatus/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	toastr.success(res.message);
                        	dataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });
            
            // code点击
            dataTable.on('click', '[data-handle="info"]', function(event) {
                var id = $(this).data('id');
                bindInfoEvent(couponsModal, id);
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function(event) {
                bindModalEvent(couponsModal, null, null);
                event.stopPropagation();
            });
            
            //批量发放
            $("#batchBtn").on('click',function(event){
            	importModalEvent(couponsModal);
            	UploadTools.createTo("fileImage", "xls", "COUPONS_PROVIDE_IMPORT", "filePath",1);
            	event.stopPropagation();
            })

        };
        
        
        var importModalEvent = function($modal) {
        	
        	
        	// 重置模式窗体内html
            $modal.html(template.render({
            	ImportModal : true,
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            //下载模板
            $("#downLoadModal").on('click', function (event) {
            	window.location.href = ctx + '/api/coupons/download?_=' + new Date().getTime();
            });

            //导入
            $("#importModal1").on('click', function (event) {
                $.excelImpTip({
                    path:$('#filePath').val(),
                    formData:$modal.find('form').serialize(),
                    formUrl:ctx + '/api/coupons/import',
                    callback:function(res) {
                        if (res.code == "1") {
                            $modal.modal('hide');
                        }
                    }
                });
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
            	modal: true,
            	suppliers : data || {}
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            setTimeout(function(){
            	initDateControl("#effectiveTime","#unEffectiveTime");
            }, 1000);

            var $form = $modal.find('form');
            
            // 表单验证
            $form.validate({
                rules: {
                	code: {
                        required: true
                    },
                    fullAmt: {
                        required: true,
                        number:true,
                        min:0
                    },
                    minusAmt: {
                        required: true,
                        number:true,
                        min:0
                    },
                    effectiveTime: {
                        required: true
                    },
                    unEffectiveTime: {
                    	required: true
                    }
                },
                submitHandler: function(form) {
                    $.ajax({
                        url: ctx + '/api/coupons/create',
                        type: 'post',
                        dataType: 'json',
                        data: $form.serialize(),
                        traditional: true,
                        cache: false,
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                dataTable.ajax.reload();
                            }
                        }
                    });
                }
            });
        };
        
        // 模式窗体绑定事件
        var bindInfoEvent = function($modal, id) {

            // 重置模式窗体内html
            $modal.html(template.render({
            	info: true
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            showProvideTab(id);
            showHistoryTab(id);
        };
        
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,  //需显示日期的元素选择器
                event: 'click', //触发事件
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                event: 'click',
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };
            laydate(startDate);
            laydate(endDate);
        }
        
        var showHistoryTab = function(id){
        	// 初始化列表
            var historyDataTable = $('#historyInfo').DataTable({
                columns: [{
    	            	data: 'id',
    	            	title: '',
    	            	defaultContent:'',
    	            	className:'td_center',
    	            	orderable: false,
    	            	width: '3%'
    				},{
                        data: 'coupons.code',
                        title: '优惠券编码',
                        orderable: false,
                        width: '15%'
                    }, {
                        data: 'coupons.fullAmt',
                        title: '优惠券规则',
                        width: '15%',
                        orderable: false,
                        render: function(data, type, full, meta) {
                        	return "满"+full.coupons.fullAmt+"元，减"+full.coupons.minusAmt+"元";
                        }
                    }, {
                        data: 'orderCode',
                        title: '总订单编号',
                        width: '15%',
                        orderable: false
                    }, {
                        data: 'user.username',
                        title: '会员名',
                        width: '15%',
                        orderable: false
                    }
                ],
                processing: true,
                serverSide: true,
                ajax: {
                	url: ctx + '/api/couponsprovide/?couponsId='+id+'&isUsed=1',
                    type: 'GET',
                    data: function(d) {
                        return $.extend(RocoUtils.buildParam(d), searchParam);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                initComplete: function() {
                    // 不显示每页多少条
                    $('#historyInfo_length').hide();
                }
            });
            
            historyDataTable.on('order.dt search.dt', function () {
            	historyDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
            }).draw();
        }

        //发放记录
        var showProvideTab = function(id){
        	// 初始化列表
            var provideDataTable = $('#provideInfo').DataTable({
                columns: [{
    	            	data: 'id',
    	            	title: '',
    	            	defaultContent:'',
    	            	className:'td_center',
    	            	orderable: false,
    	            	width: '3%'
    				},{
                        data: 'coupons.code',
                        title: '优惠券编码',
                        orderable: false,
                        width: '15%'
                    }, {
                        data: 'coupons.fullAmt',
                        title: '优惠券规则',
                        width: '15%',
                        orderable: false,
                        render: function(data, type, full, meta) {
                        	return "满"+full.coupons.fullAmt+"元，减"+full.coupons.minusAmt+"元";
                        }
                    }, {
                        data: 'createTime',
                        title: '发放时间',
                        orderable: false,
                        width: '15%'
                    }, {
                        data: 'status',
                        title: '可用状态',
                        width: '15%',
                        orderable: false,
                        render: function(data, type, full, meta) {
                        	if(data == "EFFECTIVE"){
                        		return "启用"
                        	}else if(data == "UNEFFECTIVE"){
                        		return "停用"
                        	}else{
                        		return "";
                        	}	
                        }
                    }, {
                        data: 'id',
                        title: '操作',
                        width: '10%',
                        className:'td_center',
                        orderable: false,
                        render: function(data, type, full, meta) {
                    		return template.render({
                    			provideBtn: {
                                    id: data,
                                    content: function() {
                                        return full.status == "UNEFFECTIVE" ? '启用' : '停用';
                                    },
                                    status: function() {
                                        return full.status == "UNEFFECTIVE" ? 'btn-primary' : 'btn-danger';
                                    }
                                }
                            })
                        }
                    }
                ],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/couponsprovide/?couponsId='+id+'&isUsed=0',
                    type: 'GET',
                    data: function(d) {
                        return $.extend(RocoUtils.buildParam(d), searchParam);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                initComplete: function() {
                    // 不显示每页多少条
                    $('#provideInfo_length').hide();
                }
            });
            
            provideDataTable.on('order.dt search.dt', function () {
            	provideDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
            }).draw();
            
            provideDataTable.on('click', '[data-handle="status"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/couponsprovide/updateStatus/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	toastr.success(res.message);
                        	provideDataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });
        }
        
        var init = function(){
        	 bindEvent();
        }
        
        init();

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);