(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
    	
        //高亮导航条
        RocoUtils.setSection('operation', 'exceptionorder');
        // search实现部分
        var searchForm = $('#searchForm');

        var template = Hogan.compile($('#hoganTmpl').html());
        var proList = null;
        //序号、订单号、商品、数量、积分单价、会员名、下单时间、操作
        // 初始化列表
        var dataTable = $('#orderDataTable').DataTable({
            columns: [{
            		data : "id",
            		visible:false
            	},{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '3%'
				},{
                    data: 'orderCode',
                    title: '订单号',
                    width: '10%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        return "<a href='javaScript:void(0)' data-handle='ordercode' data-id='"+full.id+"'>"+data+"</a>"
                    }
                }, {
                    data: 'productName',
                    title: '商品',
                    width: '10%',
                    render: function (data, type, full, meta) {
                    	 // 防止广告语过长,中途截断
                    	var prodName = data;
                    	if(data){
                    		if(data.length > 15){
                    			prodName = data.substr(0, 15)
                    		}
                    	}else{
                    		prodName = "";
                    	}
                    	return "<div data-toggle='popover' data-flag=false data-skuid='"+full.sku.id+"' >"+prodName+"</div>"
                    },
                    orderable: false
                }, {
                    data: 'quantity',
                    title: '数量',
                    width: '3%',
                    orderable: false
                }, {
                    data: 'cent',
                    title: '积分单价',
                    className:'td_cent',
                    width: '5%',
                    orderable: false
                }, {
                    data: 'price',
                    title: '现金单价',
                    className:'td_cent',
                    width: '5%',
                    orderable: false
                }, {
                    data: 'user.username',
                    title: '会员名',
                    width: '10%',
                    orderable: false
                }, {
                    data: 'createTime',
                    title: '下单时间',
                    width: '10%',
                    orderable: false
                }, {
                    data: 'id',
                    title: '操作',
                    width: '15%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        return template.render({
                        	showBtn : full
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url : ctx + '/api/order',
                type : 'GET',
                data : function(d) {
                    return $.extend(RocoUtils.buildParam(d), RocoUtils.parseQueryString(searchForm.serialize()));
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#orderDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

       
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var orderModal = $('#orderModal');


        // 绑定事件
        var bindEvent = function() {
        	
        	dataTable.on('mouseover','[data-toggle="popover"]',function(){
            	var id = $(this).data('skuid');
            	var _this = $(this);
            	if(_this.data('flag')) {
            		return false;
            	}
            	$.ajax({
                    url: ctx + '/api/sku/'+id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	_this.data('flag', true);
                        	var data = res.data;
                        	var mess = {
                        		"商品编码":data.code,
                        		"商品名称":data.name,
                        		"供应商":data.product.supplier.name,
                        		"商品分类":data.product.catalogs[0].name,
                        		"商品库存":data.stock+data.virtualStock-data.occupiedStock,
                        		"商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"
                        			
                        	}
                        	var content = jsonToString(mess);
                        	_this.popover({trigger:'hover',title:'商品信息',content:content,placement:'top',html:true})
                        };
                    }
                });
            })
            
            dataTable.on('mouseout','[data-toggle="popover"]',function(){
            	$(this).popover("hide");
            })
        	
        	//点击订单编号查看详情
        	dataTable.on("click","[data-handle='ordercode']",function(event){
        		var id = $(this).data('id');
        		$.ajax({
                    url: ctx + '/api/order/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == 1) {
                        	bindModalInfoEvent(orderModal,res.data);
                        }
                    }
                });
        		event.stopPropagation();
        	})
            // 修改按键点击
            dataTable.on('click', '[data-handle="edit"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/errorOrder/' + id ,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(data) {
                    	bindModalEvent(orderModal, data);
                    }
                });
                event.stopPropagation();
            });
        	
        	//通过事件
        	dataTable.on('click', '[data-handle="through"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/errorOrder/pass/' + id ,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	search();
                        }
                    }
                });
                event.stopPropagation();
            });
        	
        	//取消订单事件
        	dataTable.on('click', '[data-handle="cancel-order"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/errorOrder/cancel/' + id ,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	search();
                        }
                    }
                });
                event.stopPropagation();
            });
        	
        	//锁定|取消锁定 订单事件
        	dataTable.on('click', '[data-handle="cancel-lock"],[data-handle="lock"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/errorOrder/switchLock/' + id ,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	search();
                        }
                    }
                });
                event.stopPropagation();
            });

            $("#outStoreBtn").on('click',function(event){
            	bindModalEvent(orderModal, null);
            })
            
            //全部
            $("#allBtn").on('click',function(event){
            	$("#orderLocked").val("");
            	changeBtnColor(this);
            	search();
            })
            //未锁定
            $("#unlockBtn").on('click',function(event){
            	$("#orderLocked").val("false");
            	changeBtnColor(this);
            	search();
            })
            //锁定
            $("#lockBtn").on('click',function(event){
            	$("#orderLocked").val("true");
            	changeBtnColor(this);
            	search();
            })
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data) {
            // 重置模式窗体内html
            $modal.html(template.render({
            	modal: true,
                data : data,
                orderTotal : orderTotal(data.cent,data.cashAmt),
                orderTime : function(){
                	return RocoUtils.formatDate(new Date(data.createTime), 'yyyy-MM-dd hh:mm:ss');
                }
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            var $form = $modal.find('form');
    		// 表单验证
            $form.validate({
                rules: {
                	province: {
                        required: true,
                        maxlength: 20
                    },
                    city: {
                        required: true,
                        maxlength: 50
                    },
                    county: {
                        required: true,
                        maxlength: 20
                    },
                    recipient: {
                        required: true,
                        maxlength: 25
                    },
                    recipientPhone: {
                        required: true,
                        maxlength: 25
                    },
                    addrDetail: {
                        required: true,
                        maxlength: 25
                    },
                    postcode: {
                        required: true,
                        maxlength: 6
                    }
                },
                submitHandler: function(form) {
                	var flag = $("#flag").val();
                    $.ajax({
                        url: flag == 'save' ? ctx + '/api/errorOrder/editSave' : ctx + '/api/errorOrder/editPass',
                        type: 'post',
                        dataType: 'json',
                        data: $form.serialize(),
                        traditional: true,
                        cache: false,
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        }
                    });
                }
            });
            
            initAddress(data);
            var city = $("#cityid");
        	var county = $("#countyid");
            
            $("#provinceid").on('change',function(event){
            	city.empty();
            	county.empty();
            	var pid = setAddress2(city,this.value,$("#cityname"));
            	setAddress2(county,pid,$("#countyname"));
            	setAddress3();
            })
            
            $("#cityid").on('change',function(event){
            	county.empty();
            	setAddress2(county,this.value,$("#countyname"));
            	setAddress3();
            })
            
            $("#countyid").on('change',function(event){
            	setAddress3();
            })
            
            //保存
        	$("#saveBtn").on('click',function (event) {
        		$("#flag").val('save');
        		$form.submit();
            });
            
            //通过
        	$("#throughBtn").on('click',function (event) {
        		$("#flag").val('through');
        		$form.submit();
            });
        };
        
        //初始化收货地址
        var initAddress = function(data){
        	var pid = "";
        	var province = $("#provinceid");
        	var city = $("#cityid");
        	var county = $("#countyid");
        	pid = setAddress1(province,pid,data,"province");
        	pid = setAddress1(city,pid,data,"city");
        	setAddress1(county,pid,data,"county");
        	setAddress3();
        }
        
        //获取地址
        var getAddress = function(pid){
        	var adr = "";
        	$.ajax({
                url: pid == '' ? ctx + '/api/address/provCity' : ctx + '/api/address/provCity?pid='+pid ,
                type: 'POST',
                dataType: 'json',
                async: false,
                cache: false,
                success: function(res) {
                	adr = res;
                }
            });
        	return adr;
        }
        
        //设置地址
        var setAddress1 = function($select, pid, data,type){
        	var address = getAddress(pid);
        	var tempid = "";
        	$(address).each(function(index,datas){
        		if(!data.delivery && index == 0){
        			tempid = this.id;
        			$select.append("<option value="+this.id+" selected>"+this.name+"</option>")
        		}else if(data.delivery && data.delivery[type] == this.name){
        			tempid = this.id;
        			$select.append("<option value="+this.id+" selected>"+this.name+"</option>")
        		}else{
        			$select.append("<option value="+this.id+">"+this.name+"</option>")
        		}
        	});
        	return tempid;
        }
        
        //设置地址
        var setAddress2 = function($select, pid, $selectValue){
        	var address = getAddress(pid);
        	var tempid = "";
        	$(address).each(function(index,datas){
        		if(index == 0){
        			$select.append("<option value="+this.id+" selected>"+this.name+"</option>");
        			$selectValue.val(this.name);
        			tempid = this.id;
        		}else{
        			$select.append("<option value="+this.id+">"+this.name+"</option>");
        		}
        	});
        	return tempid;
        }
        
        var setAddress3 = function(){
        	$("#countyname").val($("#countyid option:selected").text());
        	$("#cityname").val($("#cityid option:selected").text());
        	$("#provincename").val($("#provinceid option:selected").text());
        }
        
        // 订单详细信息窗体
        var bindModalInfoEvent = function($modal, data) {
        	tempIndex = 1;
            // 重置模式窗体内html
            $modal.html(template.render({
            	OrderInfo: true,
                data : data ,
                orderTotal : orderTotal(data.orderItem.order.cent,data.orderItem.price),
                index : function(){
            		return tempIndex ++;
            	}
            }));
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
        };
        
     // 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间 参数为JQuery选择器的值 如 '#startDate'
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };

            laydate(startDate);
            laydate(endDate);
        }

        var init = function(){
        	setTimeout(initDateControl("#startDate","#endDate"), 1);
        	bindEvent();
        	$.ajax({
                url: ctx + '/api/supplier/loginedSuppliers',
                type: 'get',
                dataType: 'json',
                success: function(res) {
                    if (res.code == "1") {
                      var supplier =  $("#suppliers");
                      $(res.data).each(function(){
                    	  supplier.append("<option value="+this.id+">"+this.name+"</option>");
                      })
                    }
                }
            });
        }
        init();
        
        
        // 禁用按钮
        var btnDisable = function() {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
        
        //查询
        var search = function(){
        	searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        }
        //改变按钮颜色
        var changeBtnColor = function(_this){
        	$("#buttons").find("button").each(function(){
        		$(this).attr("class","btn btn-white btn-xs active");
        	})
        	$(_this).attr("class","btn btn-primary btn-xs active");
        }
        
        var jsonToString = function(json){
        	if(!json || json.length == 0)
        		return ""
        	var str = "";
        	$.each(json, function(i) {
        		str += i+" : "+json[i]+"</br>"
        	});
        	return str;
        }
        
      //订单合计
        var orderTotal = function(cent,price){
        	if(cent != 0 && price != 0){
        		return cent+"分 + "+price+"元";
        	}else if(price != 0){
        		return price+"元";
        	}else if(cent != 0){
        		return cent+"分";
        	}else{
        		return "";
        	}
        }
    });
    
    
})(window, document, this.jQuery, Hogan, this.RocoUtils);

