(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('data-dict', 'express');
        var winHref = window.location.href;
        var expId = "";
        if (winHref) {
			expId = winHref.substring(winHref.indexOf("?") + 1);
			$("#id").val(expId);
		}
        
        var bindEvent = function(){
        	$("#submitCitys").on('click',function(event){
        		$.ajax({
                    url: ctx + '/api/express/updatecitys',
                    type: 'POST',
                    dataType: 'json',
                    data : $('#formSubmit').serialize(),
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	toastr.success("保存成功！");
                        }
                    }
                });
                event.stopPropagation();
        	});
        	
        	$("#backBtn").on('click',function(event){
        		window.location.href = "/express"
        		event.stopPropagation();
        	});
        	
        	$("#table").on('ifChecked', "[data-handle='province']", function(e) {
        		//fromRigth = false;
        		var pid = $(this).val();
        		var selectAll = $("#table").find("[data-pid='"+pid+"']");
        		selectAll.iCheck('check');
        		selectAll.each(function(idx, item) {
                    if(!$(item).hasClass('selected')) 
                    	$(item).addClass('selected');
                })
        	});
        	
        	$("#table").on('ifUnchecked', "[data-handle='province']", function(e) {
        		//if(fromRigth) {  return false; }
        		var pid = $(this).val();
        		var selectAll = $("#table").find("[data-pid='"+pid+"']");
        		selectAll.iCheck('uncheck');
                selectAll.each(function(idx, item) {
                    $(item).removeClass('selected');
                });
        	});
        	
        	$("#table").on('ifChecked', "[data-handle='citys']", function(e) {
        		
        		var pid = $(this).data('pid');
        		var prv = $("#prv_"+pid);
        		var city = $("#table").find("[data-pid='"+pid+"']");
        		var flag = true;
        		city.each(function(){
        			if(this.checked == false){
        				flag = false;
        			}
        		});
        		if(flag){
        			prv.parent().prop("class","icheckbox_square-green checked");
            		prv.attr("checked",true);
        		}
        	});
        	
        	$("#table").on('ifUnchecked', "[data-handle='citys']", function(e) {
        		//fromRigth = true;
        		var pid = $(this).data('pid');
        		var prv = $("#prv_"+pid);
        		prv.parent().prop("class","icheckbox_square-green");
        		prv.attr("checked",false);
        		e.stopPropagation();
        	});
        }

        var init = function(){
        	$.ajax({
                url: ctx + '/api/express/gotocitys',
                type: 'POST',
                dataType: 'json',
                data : {id : expId},
                success: function(citys) {
                	initTable(citys);
                	initiChecked();
                	bindEvent();
                }
            });
        }
        
        var initiChecked = function(){
        	$('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
        }
        
        var initTable = function(data){
        	for(var i=0;i<data.length;i++){
        		var tableDate = "";
        		var flag = "checked";
        		var _this = data[i];
        		tableDate += "<td>";
        		for(var j=0;j<_this.childNodes.length;j++){
        			var citys = _this.childNodes[j];
        			if(citys.selected == true){
    					tableDate += "<span><input type='checkbox'  data-handle='citys' data-pid='"+_this.id+"' checked class='i-checks' name='citys' value='"+citys.id+"'>"+citys.name+"</span>";
    				}else{
    					tableDate += "<span><input type='checkbox' data-handle='citys' data-pid='"+_this.id+"' class='i-checks' name='citys' value='"+citys.id+"'>"+citys.name+"</span>";
    					flag = "";
    				}
        		}
    			tableDate += "</td></tr>";
        		tableDate = "<tr><td><input type='checkbox' id='prv_"+_this.id+"' "+flag+" data-handle='province' data-provid='"+_this.id+"' value='"+_this.id+"' class='i-checks'>"+_this.name+"</td>"+tableDate;
        		$("#table tr:last").after(tableDate);

        	}
        }
        
        init();
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);