(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('data-dict', 'express');

        var template = Hogan.compile($('#hoganTmpl').html());
        var expressDataTable = $("#expressDataTable");

        // 初始化列表
        var dataTable = $('#expressDataTable').DataTable({
            columns: [{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '3%'
	            },{
                    data: 'code',
                    title: '编码',
                    width: '10%'
                }, {
                    data: 'name',
                    title: '中文名称',
                    width: '10%',
                    orderable: true
                }, {
                	data: 'homeUrl',
                	title: '快递公司官网地址',
                	width: '22%',
                	render: function(data, type, full, meta) {
                		return "<a href='"+data+"' target='_Blank'>"+data+"</a>";
                	},
                	orderable: false
                }, {
                	data: 'logisticUrl',
                	title: '物流查询地址',
                	width: '23%',
                	render: function(data, type, full, meta) {
                		return "<a href='"+data+"' target='_Blank'>"+data+"</a>";
                	},
                	orderable: false
                }, {
                    data: 'status',
                    title: '状态',
                    width: '5%',
                    render: function(data, type, full, meta) {
                        return 'OPEN' == data ? '启用' : '锁定';
                    },
                    orderable: true
                }, {
                    data: 'id',
                    title: '操作',
                    width: '15%',
                    orderable: false,
                    className:'td_center',
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            editBtn: {
                                id: data,
                                content: function() {
                                    return full.status == 'OPEN' ? '锁定' : '开启';
                                },
                                status: full.status
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/express',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#expressDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var expressModal = $('#expressModal');


        // 绑定事件
        var bindEvent = function() {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/express/' + id + '/getInfo',
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(expressModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });
            
            // 添加城市 按键点击
            dataTable.on('click', '[data-handle="role-city"]', function(event) {
            	window.location.href = ctx + "/expressToCitys?"
				+ $(this).data('id');
            	event.stopPropagation();
            });

            // 锁定开启 按键点击
            expressDataTable.on('click', '[data-handle="role-operation"]', function(event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                status = status == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/express/update',
                    type: 'post',
                    dataType: 'json',
                    data: {
                    	id : id,
                        status: status
                    },
                    cache: false,
                    beforeSend: function() {
                        //btnDisable();
                    },
                    success: function(res) {
                        if (res.code == 1) {
                            toastr.success("状态修改成功");
                            // 刷新列表
                            dataTable.ajax.reload();
                            console.log(dataTable);
                        }else{
                        	toastr.error("状态修改失败");
                        }
                    },
                    complete: function() {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function(event) {
                bindModalEvent(expressModal, null, null);
                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data : data || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');
            
            
            if($("#expid").val()){
            	$("#code").attr("disabled","disabled")
            }

            // 表单验证
            $form.validate({
                rules: {
                	code: {
                		required: true,
                		maxlength: 20
                	},
                	name: {
                		required: true,
                		maxlength: 20
                	},
                	homeUrl: {
                		required: true,
                		maxlength: 200
                	},
                	logisticUrl: {
                        required: true,
                        maxlength: 200
                    }
                },
                submitHandler: function(form) {
                	
                	var formObj = {};
                    
                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/express/update') : (ctx + '/api/express/create'),
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }else{
                            	toastr.error(res.message);
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function() {
            $('#submitExpress').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#submitExpress').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);