(function(window, document, $, Hogan, RocoUtils) {
	$(function() {
	
	    RocoUtils.setSection('data-dict', 'expressTemplate');
	
		var template = Hogan.compile($('#hoganTmpl').html());
		var selectedProvMap = null;
		var selectedCityMap = null;
		
		//已经选中的省/市列表
		var submitedProvMap = new Map();
		var submitedCityMap = new Map();
		//费用item行索引号 
		var feeItemIndex= ($("#tbody").attr("init-rowIndex")) -0;
		var curNowIndex = -1;
		var checkItemSpanIdTemplate = "#prov_{provCityId}CheckedItems";
		
		// 初始化 加载控件
		var initControl = function() {
			// 复选框
			$('.i-checks').iCheck({
				checkboxClass : 'icheckbox_square-green',
				radioClass : 'iradio_square-green'
			});
			
			//编辑的时候给初始化费用Item tr绑定上时间
			for(var i=0; i<=feeItemIndex;i++){
				bindItemEvent(i+1);
			}
			
			initSubmitedProvCityMapData();
		};
		
		//编辑时初始化已占用省/市数据
		function initSubmitedProvCityMapData(){
			if(feeItemIndex>-1){
				 for(var i=0; i<=feeItemIndex;i++){
					 //处理一行
					 var rowId = i+1;
					 var selectedCityValue = $("#selectCitys_" + rowId).val();
					 if(selectedCityValue.length>0){
						 var cityNumMap  = new Map();
						 var provCityIdsMap  = new Map();
						 var selectedCityArray = selectedCityValue.split(",");
					     
						 for(var j=0;j<selectedCityArray.length; j++){
					    	 var cityId = selectedCityArray[j];
					    	 submitedCityMap.put(cityId,rowId);
					    	 var provId = $("#city_chkbox_"+cityId).attr("parent");
					    	 
					    	 if(!cityNumMap.containsKey(provId)){
					    		 cityNumMap.put(provId,1);
					    		 provCityIdsMap.put(provId,cityId);
					    	 }else {
					    		var qty = cityNumMap.get(provId);
					    		qty++;
					    		var cityIds = provCityIdsMap.get(provId);
					    		cityIds = cityIds+"," +cityId;
					    		
					    		provCityIdsMap.remove(provId);
					    		provCityIdsMap.put(provId,cityIds);

					    		cityNumMap.remove(provId);
					    		cityNumMap.put(provId,qty);
					    	 }
					     }
					     
					     var cityNameBuf = "";
					     var provIdArray = cityNumMap.keys();
					     $.each(provIdArray, function(i,pid){
					    	 var cityTotal = $("#prov_chkbox_"+pid).attr("cityNum")-0;
					    	 if(cityTotal == cityNumMap.get(pid)){
					    		 submitedProvMap.put(pid,rowId);
					    		 var provName = $("#provNameLabel"+pid).text();
					    		 cityNameBuf += provName+",";
					    	 }else {
					    		 var cityIdArray = provCityIdsMap.get(pid).split(",");
					    		 for(var c=0; c<cityIdArray.length; c++){
					    			 var cityName = $("#cityNameLabel"+cityIdArray[c]).text();
						    		 cityNameBuf += cityName+",";
					    		 }
					    	 }
					     });
					     
					     if(cityNameBuf.length>0){
					    	 $("#selectedCityNames_"+ rowId).text(cityNameBuf.substring(0,cityNameBuf.length-1));
					     }
					 }
				 }
			 }
		}
		

		// 绑定事件
		var bindEvent = function() {
			//添加新行
			$("#addNewFee").on("click",function() {
				var size = new Date().getTime();
				feeItemIndex++;
				var trHtml = "<tr id='tr_"+ size + "'>";
				trHtml += "<td>";
				trHtml += "<div class='pull-left' style='width: 190px;'><input type='checkbox' name='chkboxItems' data-row='"+size+"' style='display:none' /><div id='selectedCityNames_"+size+"'>未添加地区</div></div>";
				trHtml += "<a href='#' class='pull-right' data-handle='item-edit' data-row='"+ size + "'>编辑</a>";
				trHtml += "<input type='hidden' name='items["+feeItemIndex+"].cityIds' id='selectCitys_"+size+"' value=''/>";
				trHtml += "</td>";
				trHtml += "<td align='center'><input type='text' name='items["+feeItemIndex+"].qamt.initQuantity' seq='1' class='form-control valid' style='width: 60px;' > </td>";
				trHtml += "<td align='center'><input type='text' name='items["+feeItemIndex+"].qamt.initAmt' seq='2' class='form-control valid' style='width: 60px;' ></td>";
				trHtml += "<td align='center'><input type='text' name='items["+feeItemIndex+"].qamt.incrUnit' seq='3' class='form-control valid' style='width: 60px;' ></td>";
				trHtml += "<td align='center'><input type='text' name='items["+feeItemIndex+"].qamt.incrAmt' seq='4' class='form-control valid' style='width: 60px;' ></td>";
				trHtml += "<td class='text-center'><a href='#' data-handle='item-del' data-row='" + size + "'>删除</a></td>";
				trHtml += "</tr>";
				$("#feeTable tr").eq(-2).after(trHtml);
				bindItemEvent(-2);
			});
			//批量操作
			$("#batchOperation").on("click",function(){
				$("#op2").hide();
				$("#op1").show();
				$("#feeTable :checkbox").each(function(){
					$(this).show();
					$('#tbody').find("input[type='checkbox']").prop('checked',false);
				})
			})
			//取消 批量操作
			$("#batchCancel").on("click",function(){
				$("#op1").hide();
				$("#op2").show();
				$("#feeTable :checkbox").each(function(){
					$(this).prop("checked",false);
					$(this).hide();
				})
			})
			//全选操作
			$("#checkAll").on("click",function(){
				$("#feeTable :checkbox").prop("checked",$(this).prop("checked"));
			})
			
			//批量设置链接 
			$("#batchSetUp").on("click",function(){
			    var checkedItembox = $("#feeTable").find("input[name='chkboxItems']:checked");
				if(checkedItembox.size() == 0){
					toastr.error("请选择要批量设置的城市费用item！");
					return ;
				}
				$("#freightModel").modal();
			})
			
			
			//批量设置确认提交
			$("#batchSetupOk").on("click",function(){
				var batchQty = $("#A_").val();
				var batchRbm = $("#A_Rmb").val();
				var batchIncr = $("#A_Add").val();
				var batchIncrRmb = $("#A_Add_Rmb").val();
				var checkedItembox = $("#feeTable").find("input[name='chkboxItems']:checked");
				checkedItembox.each(function(idx,chkbox){
				   var rowId = $(chkbox).attr("data-row");
				   var inputFields = $("#tr_"+rowId).find("input[type='text']");
				   inputFields.each(function(idx,input){
					   var seq = $(input).attr("seq")-0;
				       var inputValue = null;
					   switch(seq){
						   case 1:
							   inputValue= batchQty;
							   break;
						   case 2:
							   inputValue = batchRbm;
							   break;
						   case 3:
							   inputValue = batchIncr;
							   break;
						   case 4:
							   inputValue = batchIncrRmb;
							   break;
					   }
					   $(input).val(inputValue);
				   });
				});
				
				 $("#freightModel").modal('hide');
			});
			
			//批量删除
			$("#batchDel").on("click",function(){
				var checkbox = $('#feeTable').find("input[name='chkboxItems']:checked");
				if(checkbox.size() == 0){
					toastr.error("请选择要删除的item！");
					return ;
				}
				if(confirm("确认删除选中记录吗")){
					checkbox.each(function(index,data){
						var row = $(this).data('row');
						removeTrProvCityData(row);
						$("#tr_"+row).remove();
					})
				}
			})
			//关闭
			$("#closeWin").on('click',function(event){
				window.location.href = ctx + "/expressfeelist";
                event.stopPropagation();
			});
			
            //模板form表单提交事件
            $("#submitTemplate").on('click',function(event){
            	var templateId = $("#templateId").val()-0;
                var postData = $("#feeTemplateForm").serialize();
                var postUrl = templateId>0? "/api/expressTemplate/update" : "/api/expressTemplate/create";
            	
                $.ajax({
                    url: ctx + postUrl,
                    type: 'POST',
                    dataType: 'json',
                    data: postData,
                    success: function (res) {
                        if (res.code == "1") {
                        	toastr.success(res.message);
                        	window.location.href = ctx + "/expressfeelist";
                        }
                    }
                });	
            });

			//关闭省/市窗口
			$("#closeProvCityWinBtn").on('click',function(event){
				var cityModel = $('#cityModel');
				cityModel.modal('hide');
			});
			
			//保存选中的省、市
            $("#saveProvCitybtn").on('click',function(event){
            	var cityModel = $("#cityModel");
            	var listCheckbox = cityModel.find("input[type='checkbox']");
            	var chkProvCityNames = "";
            	var chkCityIds = "";
            	listCheckbox.each(function(idx,chkbox){
            	    var self = $(chkbox);
            	    var provCityId = self.val();
            		if(self.is(":checked") && !self.attr("disabled")) {
	            		if(self.attr("checkboxType")=='prov'){
	            		 var provContainCityNum = self.attr("cityNum");
	            		 var chkCityNumTemp = checkItemSpanIdTemplate.replace("{provCityId}",provCityId);
	            		 var chkCityNumTxt = $(chkCityNumTemp).text();
	            		 var chkCityNum = chkCityNumTxt.substring(1,chkCityNumTxt.length-1);
	            		  
	            		 if(chkCityNum==provContainCityNum){
	            			 var provNameTxt = $("#provNameLabel"+provCityId).text();
		            		 chkProvCityNames += provNameTxt+",";
	            		 }
	            		 
	      			    }else{
	      			    	chkCityIds += provCityId + ",";
	      			    	var attachProvId = self.attr("parent");
	      			    	var provCheckBox = $("#prov_chkbox_"+attachProvId);
	      			    	var cityNameTxt = $("#cityNameLabel"+provCityId).text();
	      			    	//如果（城市所在的省）没有被选中或（省被选中并且下面的城市没有被全选中），则取城市名称
	      			        if(!provCheckBox.is(":checked")){
	      			        	chkProvCityNames += cityNameTxt +",";
	      			        }else {
	      			        	 var provContainCityNum = provCheckBox.attr("cityNum")-0;
		   	            		 var chkCityNumTemp = checkItemSpanIdTemplate.replace("{provCityId}",attachProvId);
		   	            		 var chkCityNumTxt = $(chkCityNumTemp).text();
		   	            		 var chkCityNum = chkCityNumTxt.substring(1,chkCityNumTxt.length-1)-0;
		   	            		 
		   	            		 //省被选中并且下面的城市没有被全选中
		   	            		 if(chkCityNum < provContainCityNum){
		   	            			chkProvCityNames += cityNameTxt +",";
		   	            		 }
	      			        }
	      			    }
            	   }
            	});
            	
            	var checkCityNames = "未添加地区";
            	if(chkProvCityNames.length>0){
            		checkCityNames = chkProvCityNames.substring(0,chkProvCityNames.length-1);
            	}
            	
            	if(chkCityIds.length>0){
            		chkCityIds = chkCityIds.substring(0,chkCityIds.length-1);
            	}
            	$("#selectedCityNames_" +curNowIndex).text(checkCityNames)
            	$("#selectCitys_" +curNowIndex).val(chkCityIds);
            
            	submitedProvMap.clear();
            	submitedCityMap.clear();
            	submitedProvMap.putMap(selectedProvMap);
            	submitedCityMap.putMap(selectedCityMap);
            	cityModel.modal('hide');
            });
   
            
            //省、市勾选
            $("#cityModel input").on('click',function(event){
            	var isChecked=$(this).is(':checked');
            	var provCityId=$(this).val();
            	var isProvince = $(this).attr("checkboxType")=='prov';
            	if(isChecked){
            		//如果是选中
            		 if(isProvince){
            			selectedProvMap.remove(provCityId);
            			selectedProvMap.put(provCityId,curNowIndex);
                         //选中省下面的所有市
                         var citysChboxSelector = "#divCityList_"+provCityId +" input[disabled!='disabled']";
       				     var checkItemSpanId = checkItemSpanIdTemplate.replace("{provCityId}",provCityId);
                         var checkCityNum = 0;
                         $(citysChboxSelector).each(function(idx,chkbox){
      					   $(chkbox).prop("checked",'checked');
      					   checkCityNum ++;
      					   selectedCityMap.remove(chkbox.value);
      					   selectedCityMap.put(chkbox.value,curNowIndex);
      				     });
      				   
      				     $(checkItemSpanId).text("("+checkCityNum+")");
            		 }else {
            			//选中城市
            		   selectedCityMap.remove(provCityId);
     			       selectedCityMap.put(provCityId,curNowIndex);
     				   var provId = $(this).attr("parent");
     				   
     				   var checkItemSpanId = checkItemSpanIdTemplate.replace("{provCityId}",provId);
                       var checkCityNum = 0;
     				   var checkCityItemText = $(checkItemSpanId).text();
     				   if(checkCityItemText.length>0){
     					   checkCityItemText = checkCityItemText.substring(1,checkCityItemText.length-1);
     					   checkCityNum = checkCityItemText -0;
     				   }
     				   checkCityNum++;
     				   $(checkItemSpanId).text("("+checkCityNum+")");
     				   var provChboxId = "#prov_chkbox_"+provId;
                       if($(provChboxId).attr("citynum") == checkCityNum){
                     	   $(provChboxId).prop("checked",'checked');
                     	   selectedProvMap.remove(provId);
                     	   selectedProvMap.put(provId,curNowIndex);
                       }
            		 }
            	}else {
                   //取消选中省            		
            		if(isProvince){
            			selectedProvMap.remove(provCityId);
                        var checkItemSpanId = checkItemSpanIdTemplate.replace("{provCityId}",provCityId);
                        $(checkItemSpanId).text("");   
                    
                 	    var citysChboxSelector = "#divCityList_"+provCityId +" input[disabled!='disabled']";
                        $(citysChboxSelector).each(function(idx,chkbox){
     					   $(chkbox).removeAttr("checked");
     					   selectedCityMap.remove(chkbox.value);
     				   });	
            		}else{
            			// 取消城市勾选
     				   var provId = $(this).attr("parent");
     			       selectedCityMap.remove(provCityId);
     			       selectedProvMap.remove(provId);
     				   
     				   var checkItemSpanId = checkItemSpanIdTemplate.replace("{provCityId}",provId);
                       var checkCityNum=0;
     				   var checkCityItemText = $(checkItemSpanId).text();
     				   if(checkCityItemText.length>0){
     					   checkCityItemText = checkCityItemText.substring(1,checkCityItemText.length-1);
     					   checkCityNum = checkCityItemText -0;
     				   }
     				   checkCityNum--;
     				   
     				   if(checkCityNum>0){
     				     $(checkItemSpanId).text("("+checkCityNum+")");
     				   }else {
     					  $(checkItemSpanId).text("");
     				   }
     				   $("#prov_chkbox_"+provId).removeAttr("checked");
            		}
            	}
            });
        };
			
		
		var bindItemEvent = function(rowIndex){
			var $tr = $("#feeTable tr").eq(rowIndex);
			//删除1行运费 
			$tr.on('click', '[data-handle="item-del"]', function(event) {
				if(confirm("确认要删除当前地区的设置么？")){
					var row = $(this).data('row');
					//删除行对应的城市和省
					removeTrProvCityData(row);
					$("#tr_"+row).remove();
				}
			});
			
			//编辑事件
			$tr.on('click', '[data-handle="item-edit"]', function(event) {
				var row = $(this).data('row');
				showModel(row);
			});
			
			$tr.find("input[type='checkbox']").on('click',function(){
				if($(this).prop("checked") == false){
					$("#checkAll").prop("checked",false);
				}else{
					
				}
			})
		}
		
		
		//删除行时,删除对应的省市数据
		function removeTrProvCityData(rowIndex){
			var rmCityIdsValue = $("#selectCitys_"+rowIndex).val();
			if(rmCityIdsValue.length>0){
				var rmCityIdArray = rmCityIdsValue.split(",");
				for(var idx=0; idx<rmCityIdArray.length; idx++){
					var cityId = rmCityIdArray[idx];
				    submitedCityMap.remove(cityId);
				    var provId = $("#city_chkbox_"+cityId).attr("parent");
				    submitedProvMap.remove(provId);
				}
			}
		}
		
		
		//展示窗体并绑定事件
		var showModel = function(index){
			//idnex  为当前行的索引
		    curNowIndex = index;
		    selectedProvMap = new Map();
		    selectedCityMap = new Map();
		    selectedProvMap.putMap(submitedProvMap);
		    selectedCityMap.putMap(submitedCityMap);
		    
		    var provCityNumMap = new Map();
		    var cityModel = $('#cityModel');
			cityModel.modal();
			
			//rowItem被选中的城市Id
			var rowItemSelectedCityIds = $('#selectCitys_'+index).val();
			var rowItemSelectedCityIdArray = rowItemSelectedCityIds.split(",");

			cityModel.find("input").each(function(){
			    var provCityId = $(this).val();
			    if($(this).attr("checkboxType")=='prov'){
			        var checkItemSpanId = checkItemSpanIdTemplate.replace("{provCityId}",provCityId);
			        $(checkItemSpanId).text("");
			        
			    	if(selectedProvMap.containsKey(provCityId)){
			    		if(selectedProvMap.get(provCityId) == index){
			    			$(this).removeAttr('disabled')
			    			$(this).prop("checked","checked");
			    		}else {
			    			$(this).prop('disabled', 'disabled');
			    			$(this).removeAttr("checked"); 	
			    		}
			    	}else {
			    		$(this).removeAttr("checked"); 	
			    	    $(this).removeAttr('disabled');
			    	}
			    }else {
			    	//城市
			    	if(selectedCityMap.containsKey(provCityId)){
			    		if(selectedCityMap.get(provCityId) == index){
			    			$(this).prop("checked","checked");
			    			$(this).removeAttr('disabled')
			    			var provId = $(this).attr("parent");
			    			if(!provCityNumMap.containsKey(provId)){
			    				provCityNumMap.put(provId,1);
			    			}else{
			    				var cityQty=provCityNumMap.get(provId);
			    				cityQty++;
			    				provCityNumMap.remove(provId);
			    				provCityNumMap.put(provId,cityQty);
			    			}
			    		1}else {
			    			$(this).prop('disabled', 'disabled');
			    			$(this).removeAttr("checked"); 	
			    		}
			    	}else {
			    		$(this).removeAttr("checked"); 	
			    	    $(this).removeAttr('disabled');
			    	}   
				}
			});
			
			 var provIdArray = provCityNumMap.keys();
			 $.each(provIdArray,function(i,provId){
			   var qty = provCityNumMap.get(provId);
			   var checkItemSpanId = checkItemSpanIdTemplate.replace("{provCityId}",provId);
			   $(checkItemSpanId).text("("+qty+")");
			 });
		}

		var init = function() {
			$.ajax({
				url : ctx + '/api/express/all',
				type : 'get',
				dataType : 'json',
				success : function(res) {
					if (res.code == "1") {
						var express = $("#expressId");
						var checkedExpId = express.attr("init-id");
						$(res.data).each(function() {
							 var selected = checkedExpId == this.id? "selected" : "";
							express.append("<option value='"+ this.id + "' "+selected+">" + this.name + "</option>");
						})
					}
				}
			});
			
			initControl();
			bindEvent();
		}

		// 初始化 加载控件
		init();
	});
})(window, document, this.jQuery, Hogan, this.RocoUtils);