(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('data-dict', 'expressTemplate');

        var template = Hogan.compile($('#hoganTmpl').html());
        var expressDataTable = $("#expressDataTable");

        // 初始化列表
        var dataTable = $('#expressDataTable').DataTable({
            columns: [{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '2%'
	            },{
                    data: 'name',
                    title: '模板名称',
                    width: '25%'
                }, {
                    data: 'calcWay',
                    title: '计价方式',
                    width: '7%',
                    orderable: false,
                	render: function(data, type, full, meta) {
                		if(data == 'A'){
                			return "按件数";
                		}else if(data == 'KG'){
                			return "按重量";
                		}else if(data == 'M3'){
                			return "按体积";
                		}else {
                			return "";
                		}
                	}
                }, {
                	data: 'express.name',
                	title: '物流公司',
                	width: '10%',
                	orderable: false
                },
                {
                	title: '默认运费',
                	width: '26%',
                	orderable: false,
                	render:function(data, type, rowObj){
                	  var temp = "initQty件内initAmt元;   每增加incrQty件,增加运费incrAmt元";
                	  temp = temp.replace("initQty",rowObj.def.initQuantity);
                	  temp = temp.replace("initAmt",rowObj.def.initAmt); 
                	  temp = temp.replace("incrQty",rowObj.def.incrUnit); 
                	  temp = temp.replace("incrAmt",rowObj.def.incrAmt); 
                	  return temp;
                	}
                },{
                    data: 'id',
                    title: '操作',
                    width: '13%',
                    orderable: false,
                    className:'td_center',
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            Btn: {
                                id: data
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/expressTemplate',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#expressDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var expressModal = $('#expressModal');


        // 绑定事件
        var bindEvent = function() {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="template-edit"]', function(event) {
                var id = $(this).data('id');
                window.location.href = ctx + "/expressTemplate/update/" +id
            });
            
            // 创建按键点击
            createBtn.on('click', function(event) {
            	window.location.href = ctx + "/expressTemplate/create";
                event.stopPropagation();
            });
            
            //复制模板
            dataTable.on('click', '[data-handle="template-clone"]', function(event) {
                
            	if(confirm("您确认要复制模板吗?")){
            	    var id = $(this).data('id');
	                var cloneApi = "/api/expressTemplate/"+id+"/clone";
	                $.ajax({
	    				url : ctx + cloneApi,
	    				type : 'get',
	    				dataType : 'json',
	    				success : function(res) {
	    					if (res.code == "1") {
	    						 window.location.href = ctx + "/expressfeelist"
	    					}
	    				}
	    			});
            	}
            	
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, rolePermissions) {
            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data : data || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
        };

        bindEvent();

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);