(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'instoreorder');

        var template = Hogan.compile($('#hoganTmpl').html());
        var instoreOrderDataTable = $("#instoreOrderDataTable");

        // 初始化列表
        var dataTable = instoreOrderDataTable.DataTable({
            columns: [{
            	data: 'id', 
            	visible:false,
            	defaultContent:''
            },{
            	data: 'index',
            	title: '',
            	defaultContent:'',
            	orderable: false,
            	width: '3%'
			},{
                data: 'code',
                title: '入库单号',
                width: '10%'
            }, {
                data: 'sku.name',
                title: '入库商品',
                width: '24%',
                orderable: true
            }, {
                data: 'quantity',
                title: '入库数量',
                width: '6%',
                orderable: false
            },{
                data: 'operator.username',
	            title: '入库人',
	            width: '7%',
	            orderable: false
	        }, {
                data: 'inType',
                title: '类型',
                width: '8%',
                orderable: false,
		        render: function (data, type, full) {
	        		return data == 'PURCHASE'? "采购入库" : "退货入库";
	            }
            }, {
                data: 'createTime',
                title: '入库时间',
                width: '12%',
                render: function (data, type, full) {
                	return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm')
                }
            }, {
            	data: 'receiveState',
	            title: '收货状态',
	            width: '8%',
	            orderable: false,
	            render:function(data, type, full){
	            	return data == 'FINISHED'? '已收货' : '未收货';
            	}
            },{
                data: 'id',
                title: '操作',
                width: '8%',
                orderable: false,
                render: function (data, type, full) {
                	if(full.receiveState == 'UNFINISHED'){
                		 return template.render({
                         	confirmReceived: true,
                             id: data
                         });
                	}
                   return '';
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/instoreOrder',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#instoreOrderDataTable_length').hide();
            }
        });
        
         //显示dataTable行号
         dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        var searchParam = null;
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var popupWindow = $('#popupWin');


        // 绑定事件
        var bindEvent = function () {
        	
            // 创建按键点击
            createBtn.on('click', function (event) {
                //bindModalEvent(vpModal, null, null);
            });
            
            //确认收货 点击事件
            instoreOrderDataTable.on('click','[data-handle="confirm-receive"]',function(){
            	
            	if(confirm('您确认收到退货吗？')){
            		var instoreOrderId = $(this).data('id');
            		var receiveApi = ctx+"/api/instoreOrder/"+instoreOrderId+"/finish";
            		
            		$.get(receiveApi,function(respJsonData){
            				if(respJsonData.code == 1){
            					toastr.success(respJsonData.message);
            					dataTable.ajax.reload(null, true);
		           			}
			           	},"json");
            		
            	}
            });
            
            //使用情况查询
            $("div#buttons").on('click','[data-instoretype]',function(){
            	$(this).parent().children().each(function(item){
            		$(this).removeClass("btn-primary");
            		$(this).addClass("btn-white");
            	});
            	$(this).removeClass("btn-white");
            	$(this).addClass("btn-primary");
            	var instoreType = $(this).data("instoretype");
            	$("input[name='instoreType']").val(instoreType);
            	searchForm.trigger("submit");
            });
        };

        // 模式窗体绑定事件
        var popupWindow = function ($modal, data) {
            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data: data || {},
                time: getTime(data)
            }));

            $modal.one('shown.bs.modal', function () {
                setTimeout(function () {
                    laydate({
                        elem: '#expired',
                        event: 'focus'
                    });
                }, 1);
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            $("#type").on("change",function(e){
            	changeModel(this.value);
            })
            
            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                submitHandler: function (form) {
                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function (idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/virtualprod/update') : (ctx + '/api/virtualprod/create'),
                        type: 'POST',
                        dataType: 'json',
                        data: $(form).serialize(),
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        }
                    });
                }
            });
        };
        

        
         function initDatepicker(){
        	   
                var initDateControl = function (start, end) {
		            var startDate = {
		                elem: start,
		                format: 'YYYY-MM-DD',//时间格式
		                min: '1900-01-01', //设定最小日期
		                max: '2099-06-16', //最大日期
		                isclear: true, //是否显示清空按钮
		                istime: false,//是否显示时间
		                istoday: true,
		                festival: true,
		                choose: function (datas) {
		                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
		                    endDate.start = datas //将结束日的初始值设定为开始日
		                }
		            };
	
		            var endDate = {
		                elem: end,
		                format: 'YYYY-MM-DD',
		                min: '1900-01-01',
		                max: '2099-06-16',
		                isclear: true,
		                istime: false,
		                istoday: true,
		                festival: true,
		                choose: function (datas) {
		                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
		                }
		            };
	               laydate(startDate);
	               laydate(endDate);
	            };
                
	         var startDateId = "#startDate";
	         var endDateId = "#endDate";
	         
	         setTimeout(initDateControl(startDateId,endDateId), 1);
         }

        function init(){
        	initDatepicker();
        	//系统初始化
        }
         
        init();
        bindEvent();
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);