(function($) {
    $.extend($, {
        excelImpTip: function(option) {
            var _option = {
                path:null,
                formData:null,
                formUrl:null,
                callback:function() {}
            };

            $.extend(_option, option);

            if(!_option.path) {
                toastr.warning("校验的文件路径不能为空!");
                return false;
            }
            else if(!_option.formUrl) {
                toastr.warning("提交表单的路径不能为空!");
                return false;
            }

            swal({
                title: "提示",
                text: "正在校验文件的正确性...",
                showConfirmButton:false
            });

            var showDialog = function(res, type, status) {
                swal({
                    title: '提示',
                    text: res.message,
                    type: "error",
                    showCancelButton: true,
                    confirmButtonText: "确认",
                    cancelButtonText: "取消",
                    closeOnConfirm: true,
                    closeOnCancel: true
                }, function(isConfirm) {
                    if (isConfirm) {
                        //swal("Deleted!", "Your imaginary file has been deleted.", "success");
                        _option.callback && _option.callback({data:res,type:type,status:status,button:'ok'});
                    } else {
                        //swal("Cancelled", "Your imaginary file is safe :)", "error");
                        _option.callback && _option.callback({data:res,type:type,status:status,button:'cancel'});
                    }
                });
            };

            // 后台文件校验
            var validateSuccess = function(res) {
                // 校验成功 提示保存
                if(res.code == "1") {
                    swal({
                        title: "提示",
                        text: "正在保存...",
                        showConfirmButton:false
                    });

                    $.ajax({
                        url: ctx + _option.formUrl,
                        type: 'post',
                        dataType: 'json',
                        data: _option.formData,
                        traditional: true,
                        cache: false,
                        success: function (res) {
                            if (res.code == "1") {
                                console.log('test1');
                                swal({
                                    title: "提示",
                                    text: res.message,
                                    type: "success",
                                    confirmButtonText: "确定",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                },
                                function (isConfirm) {
                                    console.log('test');
                                    _option.callback && _option.callback({data:res,type:'save',status:true,button:'ok'});
                                });
                            }
                            // 保存失败
                            else if(res.code == "0") {
                                showDialog(res, 'save', false);
                            }
                        }
                    });
                }
                // 校验失败
                else if(res.code == "0") {
                    showDialog(res, 'valide', false);
                }
            };

            $.ajax({
                url:ctx + '/api/upload/validateExcel',
                data:{path:_option.path},
                success:validateSuccess
            });
        }
    });
})(jQuery)