+ function($) {
    'use strick';

    function SlideContent(element, options) {
        this.options = options; //options
        this.element = element; //主dom
        this.$element = $(element); //主jquery
        this.$defaultPage = null; //用来计算宽高的隐藏内容
        this.$mainPage = null; //主页
        this.$nextPage = null; //下一页
        this.$pages = null; //所有页
        this.rect = null; //宽高对象
        this.resizeTimer = null; //resize timer
    }

    SlideContent.DEFAULTS = {
        slideEvent: 'click',
        invisibleClass: 'slide-page-invisible',
        slideToSelector:'[data-handle="slide_to"]',
        slideBackSelector:'[data-handle="slide_back"]',
        slideConfirmSelector:'[data-handle="slide_confirm"]'
    };

    // 初始化
    SlideContent.prototype.init = function() {
        // 获得页容器
        this.$pageContainer = this.$element.find('.slide-page-container');
        // 获得当前页
        this.$mainPage = this.$element.find('[data-page="main"]');
        // clone借点用来计算高度宽度
        this.$defaultPage = this.$mainPage.clone();
        // 隐身
        this.$defaultPage.addClass(this.options.invisibleClass);

        // 插入dom
        this.$defaultPage.appendTo(this.$pageContainer);
        // 角色属性改为hidden
        // this.$defaultPage.data('role','hidden');
        // 取出所有page
        this.$pages = this.$element.find('[data-role="page"]:not(.' + this.options.invisibleClass + ')');

        // 计算一下宽高
        this.rect = this.calcRect();
        this.$pageContainer.css('left', 0);
        var self = this;
        self.setPagePosition();
        self.setPageRect();

        // 转换到对应页
        self.bindEvent();
    };

    // 事件绑定
    SlideContent.prototype.bindEvent = function() {
        $(window).on('resize', this.resizeHandler.bind(this));
        this.$element.on(this.options.slideEvent, this.options.slideToSelector, this.slideTo.bind(this));
        this.$element.on(this.options.slideEvent, this.options.slideBackSelector, this.slideBack.bind(this));
        this.$element.on(this.options.slideEvent, this.options.slideConfirmSelector, this.slideConfirm.bind(this));
    };

    // resize
    SlideContent.prototype.resizeHandler = function() {
        clearTimeout(this.resizeTimer);
        var self = this;
        this.resizeTimer = setTimeout(function() {
            self.rect = self.calcRect();
            self.setPageRect();
        }, 500);
    };

    // 取出宽高
    SlideContent.prototype.calcRect = function() {
        return {
            height: this.$defaultPage.height(),
            width: this.$defaultPage.width()
        };
    };

    // 设置位置
    SlideContent.prototype.setPagePosition = function() {
        var self = this;
        self.$pages.each(function(index, element) {
            var $page = $(element);
            $page.css({
                position: 'absolute',
                top: 0,
                left: self.rect.width * index,
                zIndex: 2,
                display: index === 0 ? 'block':'none'
            });
        });
    };



    // 准备要滚动的页面
    SlideContent.prototype.preparePageSlide = function($page) {
        $page.css({
            position: 'absolute',
            top: 0,
            display: 'block',
            left: this.rect.width
        });
    };

    // 设置page 宽高
    SlideContent.prototype.setPageRect = function() {
        var rect = this.calcRect();
        this.$pageContainer.css('height', rect.height);
        this.$pages.each(function(index, element) {
            var $page = $(element);
            $page.css({
                width: rect.width,
                height: rect.height
            });
        });
    };

    // 滑过去
    SlideContent.prototype.slideTo = function(event) {

        var $target = $(event.target);
        var slideTo = $target.data('slide');

        // 设置下一页
        this.$nextPage = this.$element.find('[data-page="' + slideTo + '"]');
        console.log(this.$nextPage);
        // 滚过去之前回调
        if (this.options.beforeSlideTo && this.options.beforeSlideTo.call($target, this.$nextPage) === false) {
            return false;
        }
        this.setPagePosition();
        this.preparePageSlide(this.$nextPage);
        this.$pageContainer.css('left', this.rect.width * -1);

        // 滚过去之后回调
        this.options.afterSlideTo && this.options.afterSlideTo.call($target, this.$nextPage);
        event.stopPropagation();
    };

    // 滑回来
    SlideContent.prototype.slideBack = function(event) {
        var $target = $(event.target);

        // 滚回来之前回调
        if (this.options.beforeSlideBack && this.options.beforeSlideBack.call($target, this.$nextPage) === false) {
            return false;
        }

        this.$pageContainer.css('left', 0);

        // 滚回来之后回调
        this.options.afterSlideBack && this.options.afterSlideBack.call($target, this.$nextPage);
        event.stopPropagation();
    };

    // 确认滑回来
    SlideContent.prototype.slideConfirm = function(event) {
        var $target = $(event.target);
        // 确认滚回来前回调
        if (this.options.beforeSlideConfirm && this.options.beforeSlideConfirm.call($target, this.$nextPage) === false) {
            return false;
        }
        this.$pageContainer.css('left', 0);

        // 确认滚回来后回调
        this.options.afterSlideConfirm && this.options.afterSlideConfirm.call($target, this.$nextPage);
        event.stopPropagation();
    };

    // 销毁对象
    SlideContent.prototype.destroy = function() {
        $(window).off('resize', this.resizeHandler);
    };

    // 定义插件
    function Plugin(option, _relatedTarget) {
        // 集合插件总是返回jQuery对象
        return this.each(function() {
            var $this = $(this);
            var data = $this.data('roco.content-slide');
            var options = $.extend({}, SlideContent.DEFAULTS, $(this).data(), typeof option === 'object' && option);
            if (!data) $this.data('roco.content-slide', (data = new SlideContent(this, options)));
            if (typeof option === 'string') data[option](_relatedTarget)
            else data.init();
        });
    }

    // 保留旧对象
    var old = $.fn.slideContent;
    // 加入插件
    $.fn.slideContent = Plugin;
    // 确定构造函器
    $.fn.slideContent.Constructor = SlideContent;
    // 解决冲突函数
    $.fn.slideContent.noConflict = function() {
        $.fn.slideContent = old
        return this;
    }
}(jQuery);